/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.FRA.matcher.FRA_InternalMatchPreferences;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.CoreMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;

public final class FRA_MatcherHandler
extends CoreMatcherHandler {
    private double m_maximumAdditionalFieldScoreForSwappedAN1AN2 = 0.0;

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants constants, ScoringAddress scoringAddress) throws MatcherException {
        String pc;
        if (!candidate.isHouseNumberFromPlaceMatch() && candidate.isPointHouseCandidate(null) && StringUtilities.isEmpty((String)scoringAddress.getAddressNumber()) && !StringUtilities.isEmpty((String)candidate.getAddressNumber())) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        double originalPreTypeScore = 0.0;
        double originalPostTypeScore = 0.0;
        if (((FRA_InternalMatchPreferences)preferences).isIgnoreType()) {
            originalPreTypeScore = candidate.getPreThoroughfareTypeScore();
            originalPostTypeScore = candidate.getPostThoroughfareTypeScore();
            candidate.setPreThoroughfareTypeScore(1.0);
            candidate.setPostThoroughfareTypeScore(1.0);
        }
        boolean bManagedPreTypeScore = false;
        if (((FRA_InternalCandidateAddress)candidate).wasLDTreatedAsNoInput() && candidate.getPreThoroughfareTypeScore() == 0.75) {
            bManagedPreTypeScore = true;
            candidate.setPreThoroughfareTypeScore(1.0);
        }
        super.decideCloseMatch(preferences, candidate, constants, scoringAddress);
        if (bManagedPreTypeScore) {
            candidate.setPreThoroughfareTypeScore(0.75);
        }
        if (((FRA_InternalMatchPreferences)preferences).isIgnoreType()) {
            candidate.setPreThoroughfareTypeScore(originalPreTypeScore);
            candidate.setPostThoroughfareTypeScore(originalPostTypeScore);
        }
        if (candidate.getAreaName3Score() != 1.0 && candidate.getPostCode1Score() != 1.0 && (pc = scoringAddress.getPostCode1()) != null && pc.length() > 1 && candidate.getPostCode1() != null && !candidate.getPostCode1().startsWith(pc.substring(0, 2))) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (!this.acceptablePostDirectional(candidate.getPostDirectionalScore(), scoringAddress.getPostDirectional(), candidate.getPostDirectional())) {
            candidate.setCloseMatchFlag(false);
            return;
        }
    }

    private boolean acceptablePostDirectional(double postDirScore, String inputPostDir, String candidatePostDir) {
        if (postDirScore == 1.0) {
            return true;
        }
        if (StringUtilities.isEmpty((String)inputPostDir) || StringUtilities.isEmpty((String)candidatePostDir)) {
            return true;
        }
        return DIRECTIONAL.getDirectional(inputPostDir).acceptableDir(DIRECTIONAL.getDirectional(candidatePostDir));
    }

    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        super.scoreCandidate(candidate, scoringAddress, constants);
        if (((FRA_InternalCandidateAddress)candidate).isSwappedAN1AN2()) {
            FieldScores matchedConstants = constants.getMatched();
            FieldScores blankConstants = constants.getBlank();
            double score = candidate.getCombinedAdditionalFieldScore();
            score *= this.getMaximumAdditionalFieldScore();
            boolean hasAN1 = FRA_MatcherHandler.fieldExists((String)scoringAddress.getAreaName1());
            boolean hasAN2 = FRA_MatcherHandler.fieldExists((String)scoringAddress.getAreaName2());
            score -= (hasAN1 ? matchedConstants : blankConstants).getAreaName1() * candidate.getAreaName1Score();
            score -= (hasAN2 ? matchedConstants : blankConstants).getAreaName2() * candidate.getAreaName2Score();
            score += (hasAN1 ? blankConstants : matchedConstants).getAreaName1() * candidate.getAreaName1Score();
            candidate.setCombinedAdditionalFieldScore((score += (hasAN2 ? blankConstants : matchedConstants).getAreaName2() * candidate.getAreaName2Score()) / this.m_maximumAdditionalFieldScoreForSwappedAN1AN2);
            candidate.buildInputMatchScore((Address)scoringAddress, matchedConstants);
        }
    }

    public void computeMaximumAdditionalFieldScore(Address scoringAddress, InternalMatcherConstants constants) {
        super.computeMaximumAdditionalFieldScore(scoringAddress, constants);
        double maxScore = this.getMaximumAdditionalFieldScore();
        boolean hasAN1 = FRA_MatcherHandler.fieldExists((String)scoringAddress.getAreaName1());
        boolean hasAN2 = FRA_MatcherHandler.fieldExists((String)scoringAddress.getAreaName2());
        if (hasAN1 ^ hasAN2) {
            FieldScores matchedConstants = constants.getMatched();
            FieldScores blankConstants = constants.getBlank();
            maxScore -= (hasAN1 ? matchedConstants : blankConstants).getAreaName1();
            maxScore -= (hasAN2 ? matchedConstants : blankConstants).getAreaName2();
            maxScore += (hasAN1 ? blankConstants : matchedConstants).getAreaName1();
            maxScore += (hasAN2 ? blankConstants : matchedConstants).getAreaName2();
        }
        this.m_maximumAdditionalFieldScoreForSwappedAN1AN2 = maxScore;
    }

    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        return false;
    }

    private static enum DIRECTIONAL {
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;


        public static DIRECTIONAL getDirectional(String dir) {
            if ("N".equals(dir)) {
                return NORTH;
            }
            if ("NE".equals(dir)) {
                return NORTHEAST;
            }
            if ("E".equals(dir)) {
                return EAST;
            }
            if ("SE".equals(dir)) {
                return SOUTHEAST;
            }
            if ("S".equals(dir)) {
                return SOUTH;
            }
            if ("SO".equals(dir)) {
                return SOUTHWEST;
            }
            if ("O".equals(dir)) {
                return WEST;
            }
            if ("NO".equals(dir)) {
                return NORTHWEST;
            }
            throw new IllegalArgumentException("Unknown directional: " + dir);
        }

        public boolean acceptableDir(DIRECTIONAL dir) {
            int diff = Math.abs(this.ordinal() - dir.ordinal());
            return diff <= 2 || diff >= 6;
        }
    }
}

