/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_ScoringAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class FRA_StreetCandidateAddress
extends StreetCandidateAddress {
    public static final String ADDRESS_START = "address.start";
    public static final String ADDRESS_END = "address.end";
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String IS_MAJOR_ROAD = "is.major.road";
    public static final double THOROUGHFARE_TYPE_THRESHOLD = 0.99;
    public static final double NO_INPUT_THOROUGHFARE_TYPE_SCORE = 0.75;
    private static final String STREET_EXTRA_CHARS_TO_IGNORE = " -.";
    private int m_typeInsertedInAddress;
    private boolean m_bLDTreatedAsNoType;

    public FRA_StreetCandidateAddress() {
    }

    public FRA_StreetCandidateAddress(Address addr) {
        super(addr);
    }

    public void score(ScoringAddress input) {
        FRA_ScoringAddress scoringAddress = (FRA_ScoringAddress)input;
        this.setCountryScore(scoringAddress.scoreCountry(this.getCountry()));
        this.setGenericField1Score(scoringAddress.scoreGenericField1(this.getGenericField1()));
        this.setGenericField2Score(scoringAddress.scoreGenericField2(this.getGenericField2()));
        this.setGenericField3Score(scoringAddress.scoreGenericField3(this.getGenericField3()));
        this.setGenericField4Score(scoringAddress.scoreGenericField4(this.getGenericField4()));
        this.setPreDirectionalScore(scoringAddress.scorePostDirectional(this.getPreDirectional()));
        this.setPostDirectionalScore(scoringAddress.scorePostDirectional(this.getPostDirectional()));
        this.scoreThoroughfareType(scoringAddress);
        this.setPreAddressScore(scoringAddress.scorePreAddress(this));
        this.scoreMainAddress(scoringAddress);
        if (this.getMainAddressScore() < 0.95 && this.getConstraints().getHandler().getInputAddress().getGenericField1() == null && this.getGenericField1() != null && scoringAddress.getGenericField1() != null && this.getConstraints().getCustomString("SHIFTED_CITY_TOKENS") == null) {
            this.scoreGenericField1AsMainAddress(scoringAddress);
        }
        this.setPostAddressScore(scoringAddress.scorePostAddress(this.getPostAddress()));
        this.setIsScored(true);
    }

    private void scoreMainAddress(FRA_ScoringAddress parsedAddress) {
        if (StringUtilities.isEmpty((String)parsedAddress.getMainAddress()) && !StringUtilities.isEmpty((String)parsedAddress.getPlaceName())) {
            this.setMainAddressScore(1.0);
            return;
        }
        this.setMainAddressScore(parsedAddress.scoreMainAddress(this.getMainAddress(), this.m_typeInsertedInAddress));
        if (this.getMainAddressScore() < 0.85) {
            String originalCharsToIgnore = parsedAddress.getCharsToIgnore();
            parsedAddress.setCharsToIgnore(originalCharsToIgnore == null ? STREET_EXTRA_CHARS_TO_IGNORE : originalCharsToIgnore + STREET_EXTRA_CHARS_TO_IGNORE);
            double tempScore = parsedAddress.scoreMainAddress(this.getMainAddress(), this.m_typeInsertedInAddress);
            parsedAddress.setCharsToIgnore(originalCharsToIgnore);
            if (tempScore > 0.95) {
                this.setMainAddressScore(tempScore * 0.99);
            }
        }
    }

    private void scoreGenericField1AsMainAddress(FRA_ScoringAddress parsedAddress) {
        String originalMainAddress = parsedAddress.getMainAddress();
        parsedAddress.setMainAddress(parsedAddress.getGenericField1());
        double score = parsedAddress.scoreMainAddress(this.getGenericField1(), 0);
        if (score > 0.9 && score > this.getMainAddressScore()) {
            this.setMainAddressScore(score * 0.99);
        }
        parsedAddress.setMainAddress(originalMainAddress);
    }

    public void scoreThoroughfareType(ScoringAddress parsedAddress) {
        boolean candHasType;
        FRA_ScoringAddress scorer = (FRA_ScoringAddress)parsedAddress;
        String parsedStreetType = parsedAddress.getPreThoroughfareType();
        String candStreetType = this.getPreThoroughfareType();
        if ("LD".equals(parsedStreetType)) {
            parsedStreetType = null;
            this.setLDTreatedAsNoType(true);
        }
        boolean parsedHasType = parsedStreetType != null && parsedStreetType.length() > 0;
        boolean bl = candHasType = candStreetType != null && candStreetType.length() > 0;
        if (parsedHasType != candHasType) {
            boolean candHasPostType;
            String parsedPostStreetType = parsedAddress.getPostThoroughfareType();
            String candPostStreetType = this.getPostThoroughfareType();
            boolean parsedHasPostType = parsedPostStreetType != null && parsedPostStreetType.length() > 0;
            boolean bl2 = candHasPostType = candPostStreetType != null && candPostStreetType.length() > 0;
            if (!parsedHasPostType && candHasPostType) {
                double score = scorer.scoreItems(parsedStreetType, candPostStreetType);
                this.setPreThoroughfareTypeScore(score);
                this.setPostThoroughfareTypeScore(score);
            } else if (parsedHasPostType && !candHasPostType) {
                double score = scorer.scoreItems(parsedPostStreetType, candStreetType);
                this.setPreThoroughfareTypeScore(score);
                this.setPostThoroughfareTypeScore(score);
            } else {
                if (candHasType) {
                    this.setPreThoroughfareTypeScore(0.75);
                } else {
                    this.setPreThoroughfareTypeScore(0.5);
                }
                this.setPostThoroughfareTypeScore(scorer.scoreItems(parsedAddress.getPostThoroughfareType(), this.getPostThoroughfareType()));
            }
        } else {
            this.setPreThoroughfareTypeScore(scorer.scoreThoroughfareType(parsedStreetType, candStreetType));
            this.setPostThoroughfareTypeScore(scorer.scoreThoroughfareType(parsedAddress.getPostThoroughfareType(), this.getPostThoroughfareType()));
        }
    }

    public void setConstraints(IConstraints constraints) {
        Object check;
        super.setConstraints(constraints);
        if (constraints != null && (check = constraints.getCustomObject((Object)"KEY_TYPE_INSERTED_IN_MAIN_ADDRESS")) != null && check instanceof Integer) {
            this.m_typeInsertedInAddress = (Integer)check;
            return;
        }
        this.m_typeInsertedInAddress = 0;
    }

    public void setLDTreatedAsNoType(boolean flag) {
        this.m_bLDTreatedAsNoType = flag;
    }

    public boolean wasLDTreatedAsNoType() {
        return this.m_bLDTreatedAsNoType;
    }
}

