/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import java.util.ResourceBundle;

public class FRA_TerritoryGeocoderWrapper
implements IGeocoder {
    private final IGeocoder m_geocoder;
    private String m_Territory;

    public FRA_TerritoryGeocoderWrapper(IGeocoder geocoder, String territory) {
        this.m_geocoder = geocoder;
        this.m_Territory = territory;
    }

    public void setErrorBundle(ResourceBundle bundle) {
        this.m_geocoder.setErrorBundle(bundle);
    }

    public IConstraints convertConstraints(IConstraints constraints) {
        IConstraints constr = this.m_geocoder.convertConstraints(constraints);
        constr.setCustomString("KEY_TERRITORY_INPUT", this.m_Territory);
        return constr;
    }

    public void prepareAndParse(int geocodeType, IConstraints constraints) throws ParserException, MapMarkerInternalException {
        this.m_geocoder.prepareAndParse(geocodeType, constraints);
    }

    public GeocodeResult geocode(IConstraints preferences) throws MMInternalFatalException, MapMarkerInternalException {
        return this.m_geocoder.geocode(preferences);
    }

    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.m_geocoder.geocodePostal(constraints);
    }

    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.m_geocoder.geocodeGeographic(constraints);
    }

    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        return this.m_geocoder.geocodeCustom(geocodeType, constraints);
    }

    public GeocodeResult standardize(IConstraints preferences) throws MapMarkerInternalException {
        return this.m_geocoder.standardize(preferences);
    }

    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.m_geocoder.browse(constraints);
    }

    public CandidateAddress getIndexedCandidate(int i, IConstraints preferences) throws MapMarkerInternalException {
        CandidateAddress cand = this.m_geocoder.getIndexedCandidate(i, preferences);
        cand.setCountryMatched();
        cand.setCountry(this.m_Territory);
        return cand;
    }

    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        CandidateAddress cand = this.m_geocoder.getIndexedCoords(candIndex, range, preferences);
        cand.setCountryMatched();
        cand.setCountry(this.m_Territory);
        return cand;
    }

    public ICountryGeographyInfo getCountryGeographyInfo() {
        return this.m_geocoder.getCountryGeographyInfo();
    }
}

