/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_Geo2SacRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.FRA.parser.FRA_ParseMainAddressRule;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.HNRSConverter;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.InvalidRangeRecordFixer;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class FRA_StreetDataSourceRecordConvertorImpl
extends StreetDataSourceRecordConvertorImpl {
    private FRA_ParseMainAddressRule m_addrLineParser = new FRA_ParseMainAddressRule();
    private IConstraints constraints = new Constraints();
    private HNRSConverter m_hnrsConvertor = new HNRSConverter(false);

    public FRA_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        MMJStreetRecord record = super.createStreetRecord(input, leftSac, rightSac);
        if (record != null) {
            record.getAddress().setMainAddress(record.getAddress().getMainAddress());
        }
        return record;
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsedAddress = this.getParsedStreet(input, preParsed);
        List possibleAddrs = this.getAllPossibleMainAddresses(parsedAddress);
        return possibleAddrs;
    }

    private List getAllPossibleMainAddresses(Address parsedAddress) {
        if (parsedAddress == null) {
            return Collections.EMPTY_LIST;
        }
        String primaryName = parsedAddress.getGenericField1();
        if (primaryName == null || primaryName.length() == 0) {
            primaryName = parsedAddress.getMainAddress();
            DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: makeAllPossibleMainAddresses(): No GenericField1 in parsed address. (MainAddress: " + primaryName + ")");
        }
        List<String> uniqueMainAddrLines = this.createUniqueStreetNamesForSoundexGeneration(primaryName);
        ArrayList<AddressImpl> list = new ArrayList<AddressImpl>();
        for (String s : uniqueMainAddrLines) {
            AddressImpl tmp = new AddressImpl(parsedAddress);
            tmp.setGenericField4(s);
            list.add(tmp);
        }
        return list;
    }

    public List<String> createUniqueStreetNamesForSoundexGeneration(String main) {
        if (!StringUtilities.isEmpty((String)main)) {
            ISoundexKey key;
            String temp;
            int idx;
            ISoundexKey key2;
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<ISoundexKey> uniqueSoundexKeys = new ArrayList<ISoundexKey>();
            if (!list.contains(main = FRA_Standardizer.standardizeString(main)) && !uniqueSoundexKeys.contains(key2 = this.makeSoundexKey(main))) {
                list.add(main);
                uniqueSoundexKeys.add(key2);
            }
            if ((idx = (temp = main).lastIndexOf(32)) > 0 && !list.contains(temp = temp.substring(idx + 1)) && !uniqueSoundexKeys.contains(key = this.makeSoundexKey(temp))) {
                list.add(temp);
                uniqueSoundexKeys.add(key);
            }
            if (!(StringUtilities.isEmpty((String)(temp = FRA_Standardizer.stripDigitsAndOrdinals(main))) || list.contains(temp) || uniqueSoundexKeys.contains(key = this.makeSoundexKey(temp)))) {
                list.add(temp);
                uniqueSoundexKeys.add(key);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new FRA_Geo2SacRecord();
    }

    protected MapMarkerIndexKey makeStreetSearchKey(Address address, int sac) {
        FRA_SoundexKey sndxKey;
        String keyString = address.getGenericField4();
        if (StringUtilities.isEmpty((String)keyString)) {
            keyString = address.getMainAddress();
        }
        if ((sndxKey = (FRA_SoundexKey)this.makeSoundexKey(keyString)) == null) {
            return null;
        }
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)new MiSoundexKey((MiSoundexKey)sndxKey));
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        String keyString = address.getGenericField4();
        if (StringUtilities.isEmpty((String)keyString)) {
            keyString = address.getMainAddress();
        }
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = keyString.charAt(0);
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey)};
        return keys;
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        StringBuffer buf = new StringBuffer(100);
        if ("BP".equals(input.getMainAddress()) || "CS".equals(input.getMainAddress())) {
            buf.append(input.getMainAddress().trim());
            buf.append(" 100A");
        } else if (inputStreetAddress.getMainAddress().startsWith("100 ")) {
            buf.append(inputStreetAddress.getMainAddress());
            buf.insert(3, 'A');
        } else {
            buf.append("100A ");
            buf.append(inputStreetAddress.getMainAddress());
        }
        inputStreetAddress.setMainAddress(buf.toString());
        Address parsedAddress = this.parseStreet(inputStreetAddress);
        if (parsedAddress == null) {
            DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        if (parsedAddress.getMainAddress() == null) {
            DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.");
            return null;
        }
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100A") && parsedAddress.getUnitValue() == null && parsedAddress.getUnitType() == null) {
            parsedAddress.setAddressNumber((String)null);
            parsedAddress.setUnitType(null);
            parsedAddress.setUnitValue(null);
            return parsedAddress;
        }
        buf.append(" APP 1");
        inputStreetAddress.setMainAddress(buf.toString());
        parsedAddress = this.parseStreet(inputStreetAddress);
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100A") && this.stringExists(parsedAddress.getUnitType()) && parsedAddress.getUnitType().equalsIgnoreCase("APP") && this.stringExists(parsedAddress.getUnitValue()) && parsedAddress.getUnitValue().equalsIgnoreCase("1")) {
            parsedAddress.setAddressNumber((String)null);
            parsedAddress.setUnitType(null);
            parsedAddress.setUnitValue(null);
            return parsedAddress;
        }
        buf.insert(5, "COTE ");
        inputStreetAddress.setMainAddress(buf.toString());
        parsedAddress = this.parseStreet(inputStreetAddress);
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100A") && this.stringExists(parsedAddress.getPreThoroughfareType()) && parsedAddress.getPreThoroughfareType().equalsIgnoreCase("COTE") && this.stringExists(parsedAddress.getUnitType()) && parsedAddress.getUnitType().equalsIgnoreCase("APP") && this.stringExists(parsedAddress.getUnitValue()) && parsedAddress.getUnitValue().equalsIgnoreCase("1")) {
            parsedAddress.setAddressNumber((String)null);
            parsedAddress.setPreThoroughfareType(null);
            parsedAddress.setUnitType(null);
            parsedAddress.setUnitValue(null);
            return parsedAddress;
        }
        DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.  Unable to proceed.");
        return null;
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        String test = this.m_dataProperties.getProperty("AP_PROCESSING");
        if (StringUtilities.equalStringsIgnoreCase((String)test, (String)"true")) {
            return 0;
        }
        return this.m_hnrsConvertor.getOddEven(input);
    }

    protected boolean fixInvalidRange(MMJRangeRecord range) {
        InvalidRangeRecordFixer.fixInvalidRange((MMJRangeRecord)range);
        return true;
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord segment = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        if (!convertLeft) {
            segment.setLeftPostalCode1(null);
        } else if (!convertRight) {
            segment.setRightPostalCode1(null);
        }
        return segment;
    }
}

