/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.FRA.FRA_Segment;
import com.mapinfo.mapmarker.FRA.FRA_StreetCandidateAddress;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GenericAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.TAIntermediateRangeRecord;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Properties;

public class FRA_AddressFetcher
extends GenericAddressFetcher {
    static NumberFormat postalFormatter = NumberFormat.getInstance();

    public FRA_AddressFetcher(Properties localSettings, Properties localStrings) {
        super(localSettings, localStrings);
        postalFormatter.setMinimumIntegerDigits(5);
        postalFormatter.setMaximumIntegerDigits(5);
        postalFormatter.setGroupingUsed(false);
    }

    public NumberFormat getPostalFormatter() {
        return postalFormatter;
    }

    protected Segment makeSegment() {
        return new FRA_Segment();
    }

    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        super.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
        IGeoInfoFetcher fetcher = dict.getGeoInfoFetcher();
        FRA_Segment fraSegment = (FRA_Segment)segment;
        boolean hasLeftGeoInfo = false;
        boolean hasRightGeoInfo = false;
        if (fetcher != null) {
            long geoOffset = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericSegment);
            FRA_GeoInfoRecord geoRecord = null;
            if (geoOffset != 0L) {
                geoRecord = (FRA_GeoInfoRecord)fetcher.getGeoInfoRecord(geoOffset);
            }
            if (geoRecord != null) {
                fraSegment.setGeoInfoRecord(geoRecord);
                hasRightGeoInfo = true;
                hasLeftGeoInfo = true;
            } else {
                geoOffset = GenericDataItemAccessor.getDataLong((int)32, (GenericDataItem)genericSegment);
                FRA_GeoInfoRecord fRA_GeoInfoRecord = geoRecord = geoOffset == 0L ? null : (FRA_GeoInfoRecord)fetcher.getGeoInfoRecord(geoOffset);
                if (geoRecord != null) {
                    fraSegment.setLeftGeoInfoRecord(geoRecord);
                    hasLeftGeoInfo = true;
                }
                FRA_GeoInfoRecord fRA_GeoInfoRecord2 = geoRecord = (geoOffset = GenericDataItemAccessor.getDataLong((int)33, (GenericDataItem)genericSegment)) == 0L ? null : (FRA_GeoInfoRecord)fetcher.getGeoInfoRecord(geoOffset);
                if (geoRecord != null) {
                    fraSegment.setRightGeoInfoRecord(geoRecord);
                    hasRightGeoInfo = true;
                }
            }
        }
        if (!hasLeftGeoInfo || !hasRightGeoInfo) {
            this.populateSegmentFromFields(fraSegment, genericSegment, !hasLeftGeoInfo, !hasRightGeoInfo);
        }
        if (!hasRightGeoInfo && fraSegment.getRightAreaName3() == null && fraSegment.getRightAreaName2() != null && fraSegment.getLeftAreaName3() != null) {
            fraSegment.setRightAreaName3(fraSegment.getLeftAreaName3());
            fraSegment.setRightOriginalAreaName3(fraSegment.getLeftOriginalAreaName3());
        }
        if (!hasLeftGeoInfo && fraSegment.getLeftAreaName3() == null && fraSegment.getLeftAreaName2() != null && fraSegment.getRightAreaName3() != null) {
            fraSegment.setLeftAreaName3(fraSegment.getLeftOriginalAreaName3());
            fraSegment.setLeftOriginalAreaName3(fraSegment.getRightOriginalAreaName3());
        }
    }

    private void populateSegmentFromFields(FRA_Segment fraSegment, GenericSegment genericSegment, boolean doLeft, boolean doRight) throws LocalizationException {
        String areaname;
        if (genericSegment.hasString(32)) {
            areaname = GenericDataItemAccessor.getDataString((int)32, (GenericDataItem)genericSegment);
            if (doLeft) {
                fraSegment.setLeftOriginalAreaName1(areaname);
            }
            if (doRight) {
                fraSegment.setRightOriginalAreaName1(areaname);
            }
        } else {
            if (doLeft) {
                if (genericSegment.hasString(36)) {
                    areaname = GenericDataItemAccessor.getDataString((int)36, (GenericDataItem)genericSegment);
                    fraSegment.setLeftOriginalAreaName1(areaname);
                } else {
                    fraSegment.setLeftOriginalAreaName1(fraSegment.getLeftAreaName1());
                }
            }
            if (doRight) {
                if (genericSegment.hasString(40)) {
                    areaname = GenericDataItemAccessor.getDataString((int)40, (GenericDataItem)genericSegment);
                    fraSegment.setRightOriginalAreaName1(areaname);
                } else {
                    fraSegment.setRightOriginalAreaName1(fraSegment.getRightAreaName1());
                }
            }
        }
        if (genericSegment.hasString(33)) {
            areaname = GenericDataItemAccessor.getDataString((int)33, (GenericDataItem)genericSegment);
            if (doLeft) {
                fraSegment.setLeftOriginalAreaName2(areaname);
            }
            if (doRight) {
                fraSegment.setRightOriginalAreaName2(areaname);
            }
        } else {
            if (doLeft) {
                if (genericSegment.hasString(37)) {
                    areaname = GenericDataItemAccessor.getDataString((int)37, (GenericDataItem)genericSegment);
                    fraSegment.setLeftOriginalAreaName2(areaname);
                } else {
                    fraSegment.setLeftOriginalAreaName2(fraSegment.getLeftAreaName2());
                }
            }
            if (doRight) {
                if (genericSegment.hasString(41)) {
                    areaname = GenericDataItemAccessor.getDataString((int)41, (GenericDataItem)genericSegment);
                    fraSegment.setRightOriginalAreaName2(areaname);
                } else {
                    fraSegment.setRightOriginalAreaName2(fraSegment.getRightAreaName2());
                }
            }
        }
        if (genericSegment.hasString(34)) {
            areaname = GenericDataItemAccessor.getDataString((int)34, (GenericDataItem)genericSegment);
            if (doLeft) {
                fraSegment.setLeftOriginalAreaName3(areaname);
            }
            if (doRight) {
                fraSegment.setRightOriginalAreaName3(areaname);
            }
        } else {
            if (doLeft) {
                if (genericSegment.hasString(38)) {
                    areaname = GenericDataItemAccessor.getDataString((int)38, (GenericDataItem)genericSegment);
                    fraSegment.setLeftOriginalAreaName3(areaname);
                } else {
                    fraSegment.setLeftOriginalAreaName3(fraSegment.getLeftAreaName3());
                }
            }
            if (doRight) {
                if (genericSegment.hasString(42)) {
                    areaname = GenericDataItemAccessor.getDataString((int)42, (GenericDataItem)genericSegment);
                    fraSegment.setRightOriginalAreaName3(areaname);
                } else {
                    fraSegment.setRightOriginalAreaName3(fraSegment.getRightAreaName3());
                }
            }
        }
        if (genericSegment.hasString(35)) {
            areaname = GenericDataItemAccessor.getDataString((int)35, (GenericDataItem)genericSegment);
            if (doLeft) {
                fraSegment.setLeftOriginalAreaName4(areaname);
            }
            if (doRight) {
                fraSegment.setRightOriginalAreaName4(areaname);
            }
        } else {
            if (doLeft) {
                if (genericSegment.hasString(39)) {
                    areaname = GenericDataItemAccessor.getDataString((int)39, (GenericDataItem)genericSegment);
                    fraSegment.setLeftOriginalAreaName4(areaname);
                } else {
                    fraSegment.setLeftOriginalAreaName4(fraSegment.getLeftAreaName4());
                }
            }
            if (doRight) {
                if (genericSegment.hasString(43)) {
                    areaname = GenericDataItemAccessor.getDataString((int)43, (GenericDataItem)genericSegment);
                    fraSegment.setRightOriginalAreaName4(areaname);
                } else {
                    fraSegment.setRightOriginalAreaName4(fraSegment.getRightAreaName4());
                }
            }
        }
        if (genericSegment.hasInteger(32)) {
            String postcode = this.generatePostCodeFromInt(GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericSegment));
            if (doLeft) {
                fraSegment.setLeftPostCode1(postcode);
            }
            if (doRight) {
                fraSegment.setRightPostCode1(postcode);
            }
        } else {
            String postcode;
            if (doLeft && genericSegment.hasInteger(33)) {
                postcode = this.generatePostCodeFromInt(GenericDataItemAccessor.getDataInt((int)33, (GenericDataItem)genericSegment));
                fraSegment.setLeftPostCode1(postcode);
            }
            if (doRight && genericSegment.hasInteger(34)) {
                postcode = this.generatePostCodeFromInt(GenericDataItemAccessor.getDataInt((int)34, (GenericDataItem)genericSegment));
                fraSegment.setRightPostCode1(postcode);
            }
        }
    }

    private String generatePostCodeFromInt(int pc) {
        StringBuilder sb = new StringBuilder(String.valueOf(pc));
        while (sb.length() < 5) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        super.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
        if (range.getIntermediateRecordArray() == null && range.getParsedFrom() != null && range.getParsedTo() != null && !range.getParsedFrom().isPureNumeric() && range.getParsedFrom().equals((Object)range.getParsedTo())) {
            range.setIntermediateRecordArray(new TAIntermediateRangeRecord(range.getParsedFrom().getCombinedAddressNumber()).getIntermediateDataRecords());
        }
    }

    public InternalCandidateAddress makeInternalCandidateAddress() {
        return new FRA_InternalCandidateAddress();
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new FRA_InternalCandidateAddress((Address)street);
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new FRA_StreetCandidateAddress();
    }
}

