/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.ud.tab;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.dp.FRA_DataConstructionParser;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_MMJAltFileCreatorRunner;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_MetadataBuilder;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_StreetBuilder;
import com.mapinfo.mapmarker.FRA.dp.ud.FRA_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.FRA.dp.ud.tab.FRA_UDGeoInfoDataHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class FRA_TabUDDataProvider
extends AbstractUDDataProvider {
    private MMJComplexDataFileMetadata m_streetMetadata = null;
    private String m_udPath;
    private static final int DATATYPE_USER_DICTIONARY = 10;

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = FRA_MetadataBuilder.buildMetadata();
            this.m_streetMetadata.setVendorCode(10);
        }
        return this.m_streetMetadata;
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_dataBuilder = new FRA_StreetBuilder();
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_postInfoDataHandler = null;
        this.m_geoInfoDataHandler = null;
        this.m_udPath = processingProperties.getProperty("street_outputFilePath");
        Constraints constraints = new Constraints();
        FRA_UDStreetDataSourceRecordConvertor convertor = new FRA_UDStreetDataSourceRecordConvertor(processingProperties, (UDPost2SacDataHandler)this.m_post2sacDataHandler, (UDGeo2SacDataHandler)this.m_geo2sacDataHandler, new FRAFrenchSoundex(), new CollationKeyGenerator(new Locale("fr", "FRA"), FRA_ScoringHelper.getCollationRules()), new FRA_DataConstructionParser(), constraints, (FRA_UDGeoInfoDataHandler)this.m_geoInfoDataHandler);
        this.m_streetDataHandler = new TabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)convertor, (IIntermediateDataHandler)new IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp")), (MMJStreetRecordComparator)new FRA_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
    }

    @Override
    protected void createAlt() throws DataCreationException {
        FRA_MMJAltFileCreatorRunner AltCreator = new FRA_MMJAltFileCreatorRunner();
        try {
            AltCreator.createFile(this.m_udPath);
        }
        catch (IOException ioEx) {
            DataCreationLogger.getLogger().logStatus("Error creating alt.mmj: ");
            throw new DataCreationException(105, (Throwable)ioEx);
        }
    }
}

