/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.filters;

import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class BetterProperNameMatchFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        FRA_InternalCandidateAddress best = (FRA_InternalCandidateAddress)bestCandidate;
        FRA_InternalCandidateAddress other = (FRA_InternalCandidateAddress)otherCandidate;
        double bestScore = best.getMainAddressScore();
        double otherScore = other.getMainAddressScore();
        if (bestScore == 1.0 || bestScore <= otherScore) {
            return false;
        }
        if (best.getAreaName1Score() != other.getAreaName1Score() || best.getAreaName2Score() != other.getAreaName2Score() || best.getAreaName3Score() != other.getAreaName3Score() || best.getAreaName4Score() != other.getAreaName4Score() || best.getPostCode1Score() != other.getPostCode1Score()) {
            return false;
        }
        if (best.getAddressNumberScore() >= other.getAddressNumberScore() && best.getPlaceNameScore() >= other.getPlaceNameScore() && best.getPreThoroughfareTypeScore() >= other.getPreThoroughfareTypeScore() && best.getPostThoroughfareTypeScore() >= other.getPostThoroughfareTypeScore() && best.getPostDirectionalScore() >= other.getPostDirectionalScore()) {
            String bestMain = best.getMainAddress();
            String otherMain = other.getMainAddress();
            int bestSpaceIdx = bestMain.indexOf(32);
            int otherSpaceIdx = otherMain.indexOf(32);
            if (bestSpaceIdx > 0 && otherSpaceIdx < 0) {
                return FRA_ScoringHelper.isCommonNamedStreetPrefix(bestMain.substring(0, bestSpaceIdx));
            }
        }
        return false;
    }
}

