/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.parser;

import com.mapinfo.mapmarker.common.Address;
import java.util.HashMap;
import java.util.Map;

public class FRA_Directionals {
    private static final Map m_directionalMap;
    private static final Map m_directionalFullNameMap;

    private FRA_Directionals() {
    }

    public static String getAbbreviation(String directional) {
        String abbrev = (String)m_directionalMap.get(directional);
        if (abbrev != null) {
            return abbrev;
        }
        if (directional.charAt(directional.length() - 1) == '.') {
            return (String)m_directionalMap.get(directional.substring(0, directional.length() - 1));
        }
        return null;
    }

    public static String getFullName(String directional) {
        String fullName = (String)m_directionalFullNameMap.get(directional);
        if (fullName != null) {
            return fullName;
        }
        if (directional.charAt(directional.length() - 1) == '.') {
            return (String)m_directionalFullNameMap.get(directional.substring(0, directional.length() - 1));
        }
        return null;
    }

    public static boolean isDirectional(String directional) {
        if (directional == null) {
            return false;
        }
        if (m_directionalMap.containsKey(directional)) {
            return true;
        }
        if (directional.charAt(directional.length() - 1) == '.') {
            return m_directionalMap.containsKey(directional.substring(0, directional.length() - 1));
        }
        return false;
    }

    public static boolean removePreDirectional(Address address) {
        String tmp;
        String main = address.getMainAddress();
        boolean foundDir = false;
        if (main.startsWith("EST")) {
            String tmp2 = main.substring(3);
            if (tmp2.length() != 0) {
                address.setPreDirectional("E");
                address.setMainAddress(tmp2);
                foundDir = true;
            }
        } else if (main.startsWith("OUEST")) {
            String tmp3 = main.substring(5);
            if (tmp3.length() != 0) {
                address.setPreDirectional("O");
                address.setMainAddress(tmp3);
                foundDir = true;
            }
        } else if (main.startsWith("NORD")) {
            String tmp4 = main.substring(4);
            if (tmp4.length() != 0) {
                address.setPreDirectional("N");
                address.setMainAddress(tmp4);
                foundDir = true;
            }
        } else if (main.startsWith("SUD") && (tmp = main.substring(3)).length() != 0) {
            address.setPreDirectional("S");
            address.setMainAddress(tmp);
            foundDir = true;
        }
        return foundDir;
    }

    static {
        int i;
        String[] directionals = new String[]{"N", "S", "E", "O", "N.", "S.", "E.", "O.", "NORD", "SUD", "EST", "OUEST", "NE", "N.E.", "NORDEST", "NORD-EST", "SE", "S.E.", "SUDEST", "SUD-EST", "NO", "N.O.", "NORDOUEST", "NORD-OUEST", "SO", "S.O.", "SUDOUEST", "SUD-OUEST"};
        String[] directionalName = new String[]{"Nord", "Sud", "Est", "Ouest", "Nord", "Sud", "Est", "Ouest", "Nord", "Sud", "Est", "Ouest", "Nord-Est", "Nord-Est", "Nord-Est", "Nord-Est", "Sud-Est", "Sud-Est", "Sud-Est", "Sud-Est", "Nord-Ouest", "Nord-Ouest", "Nord-Ouest", "Nord-Ouest", "Sud-Ouest", "Sud-Ouest", "Sud-Ouest", "Sud-Ouest"};
        String[] abbreviation = new String[]{"N", "S", "E", "O", "N", "S", "E", "O", "N", "S", "E", "O", "NE", "NE", "NE", "NE", "SE", "SE", "SE", "SE", "NO", "NO", "NO", "NO", "SO", "SO", "SO", "SO"};
        m_directionalMap = new HashMap(directionals.length);
        for (i = 0; i < directionals.length; ++i) {
            m_directionalMap.put(directionals[i], abbreviation[i]);
        }
        m_directionalFullNameMap = new HashMap(directionals.length);
        for (i = 0; i < directionals.length; ++i) {
            m_directionalFullNameMap.put(directionals[i], directionalName[i]);
        }
    }
}

