/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.parser;

import com.mapinfo.mapmarker.FRA.parser.FRA_Directionals;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareType;
import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.FRA.parser.FRA_UnitType;
import com.mapinfo.mapmarker.FRA.parser.FRA_UnitTypes;
import com.mapinfo.mapmarker.FRA.singleline.FRA_SingleLineComparatorUtils;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.HashSet;

public class FRA_ParseMainAddressRule
implements IParseRule {
    private static final FRA_ThoroughfareTypes m_tfareTypes = new FRA_ThoroughfareTypes();
    private static final String m_mainAddrTokenSeparators = " ,.";
    static HashSet<String> m_compoundHouseNumberSeparators = null;
    private ParsedNumber bpPN = null;
    private ParsedNumber cedexPN = null;
    private boolean hasBP;
    private boolean hasCedex;
    private boolean bpHnrPossibleStreetHnr;
    private boolean cedexHnrPossibleStreetHnr;
    boolean isCSBox;

    public void parse(Address ura, Address inParsedAddress, IConstraints constraints) throws ParserException {
        String testDir;
        ParsedNumber pn;
        this.isCSBox = false;
        FRA_ThoroughfareType postType = null;
        FRA_ThoroughfareType preType = null;
        AddressImpl pa = new AddressImpl(inParsedAddress);
        String upMainAddress = null;
        String upSecondLine = null;
        StringWithTokens secondLineTokens = null;
        StringWithTokens mainAddrTokens = null;
        String inputMainAddress = null;
        if (ura == null) {
            throw new ParserException(2000);
        }
        if (pa == null) {
            throw new ParserException(2001);
        }
        this.RemoveBadChars((Address)pa);
        if (constraints != null && pa.getMainAddress() == null && pa.getGenericField1() != null) {
            pa.setMainAddress(pa.getGenericField1());
            pa.setGenericField1("");
        }
        if (ura.getGenericField1() != null && ura.getGenericField1().length() != 0) {
            AddressImpl secondLineParse = new AddressImpl(ura);
            String buf = ura.getGenericField1().trim();
            upSecondLine = buf.toUpperCase();
            secondLineTokens = new StringWithTokens(upSecondLine, m_mainAddrTokenSeparators);
            FRA_ThoroughfareType postTypesl = null;
            if (secondLineTokens != null && secondLineTokens.size() != 0) {
                String testDir2;
                this.getHouseNumber((Address)secondLineParse, secondLineTokens, constraints);
                postTypesl = m_tfareTypes.findStreetType(secondLineTokens, false);
                if (postTypesl == null && FRA_Directionals.isDirectional(testDir2 = secondLineTokens.getLastToken())) {
                    secondLineTokens.removeLast();
                    postTypesl = m_tfareTypes.findStreetType(secondLineTokens, false);
                }
                secondLineTokens = new StringWithTokens(upSecondLine, m_mainAddrTokenSeparators);
            }
        }
        if (pa.getMainAddress() != null && pa.getMainAddress().length() != 0) {
            inputMainAddress = pa.getMainAddress().trim();
            upMainAddress = FRA_Standardizer.toUpperCaseWithoutAccents(inputMainAddress);
            String altMainAddress = this.getFullAddressString(ura);
            if (altMainAddress != null) {
                upMainAddress = FRA_Standardizer.toUpperCaseWithoutAccents(altMainAddress);
                pa.setAddressNumber("");
                pa.setPostThoroughfareType("");
                pa.setPreThoroughfareType("");
                pa.setPreDirectional("");
                pa.setPostDirectional("");
            }
            if (upSecondLine != null && upSecondLine.length() != 0) {
                if (!upMainAddress.equals("")) {
                    upMainAddress = upMainAddress + " ";
                }
                upMainAddress = upMainAddress + upSecondLine;
            }
            mainAddrTokens = new StringWithTokens(FRA_Standardizer.removePunctuation(upMainAddress), m_mainAddrTokenSeparators);
        }
        pa.setMainAddress("");
        if (upMainAddress == null && upSecondLine == null && (pa.getPlaceName() == null || pa.getPlaceName().length() == 0)) {
            this.copyFields(inParsedAddress, (Address)pa);
            return;
        }
        if (mainAddrTokens == null || mainAddrTokens.size() == 0) {
            this.copyFields(inParsedAddress, (Address)pa);
            return;
        }
        if ((mainAddrTokens = this.findSpecialAddressFormats((Address)pa, mainAddrTokens)).size() == 0) {
            if (pa.getMainAddress() != null && (pa.getMainAddress().startsWith("BP") || pa.getMainAddress().startsWith("CS"))) {
                pa.getAdditionalFields().put(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD, "true");
            } else if (pa.getMainAddress() != null && pa.getMainAddress().startsWith("CEDEX")) {
                pa.getAdditionalFields().put(AddressImpl.POB2_IN_MAIN_ADDRESS_FIELD, "true");
            }
            this.copyFields(inParsedAddress, (Address)pa);
            return;
        }
        StringWithTokens origToks = new StringWithTokens(mainAddrTokens.toString());
        this.getHouseNumber((Address)pa, mainAddrTokens, constraints);
        if (this.emptiedTokens(mainAddrTokens)) {
            if (mainAddrTokens.size() < 2) {
                pa.setMainAddress(this.createMainAddressString(origToks));
                pa.setAddressNumber((String)null);
                this.copyFields(inParsedAddress, (Address)pa);
                return;
            }
            mainAddrTokens = new StringWithTokens(origToks.getLastToken());
        }
        if (origToks.size() != mainAddrTokens.size()) {
            origToks = new StringWithTokens(mainAddrTokens.toString());
        }
        if ((preType = m_tfareTypes.findStreetType(mainAddrTokens, true)) != null) {
            pa.setPreThoroughfareType(preType.getPreferredTypeName());
            for (int cnt = 0; cnt < preType.getNumTokens(); ++cnt) {
                mainAddrTokens.removeFirst();
            }
            boolean bResetOrigToks = false;
            if (this.emptiedTokens(mainAddrTokens)) {
                pn = pa.getParsedAddressNumber();
                if (pn != null && preType.canEnd()) {
                    if (pn.hasNumberSeparator() && pn.hasAddressSuffix()) {
                        mainAddrTokens = new StringWithTokens(pn.getAddressSuffix());
                        pn.setAddressSuffix(null);
                        pn.setNumberSeparator(null);
                        pa.setAddressNumber(pn);
                        pa.setPreThoroughfareType(null);
                        bResetOrigToks = true;
                        pa.setPostThoroughfareType(preType.getPreferredTypeName());
                    } else if (pn.hasNumberSeparator() && pn.getSuffixNumberExists()) {
                        mainAddrTokens = new StringWithTokens(pn.getSuffixNumberAsString());
                        pn.setSuffixNumberExists(false);
                        pn.setNumberSeparator(null);
                        pa.setAddressNumber(pn);
                        pa.setPreThoroughfareType(null);
                        bResetOrigToks = true;
                        pa.setPostThoroughfareType(preType.getPreferredTypeName());
                    } else {
                        mainAddrTokens = new StringWithTokens(pn.getCombinedAddressNumber());
                        pa.setAddressNumber("");
                        pa.setPreThoroughfareType(null);
                        bResetOrigToks = true;
                        pa.setPostThoroughfareType(preType.getPreferredTypeName());
                    }
                } else {
                    mainAddrTokens = origToks;
                    pa.setPreThoroughfareType(null);
                }
            }
            if (bResetOrigToks || origToks.size() != mainAddrTokens.size()) {
                origToks = new StringWithTokens(mainAddrTokens.toString());
            }
        }
        boolean bPostType = false;
        if (preType == null) {
            postType = m_tfareTypes.findStreetType(mainAddrTokens, false);
            if (postType != null) {
                if (postType.foundAtEnd() || mainAddrTokens.size() == postType.getNumTokens() && postType.foundAtStart()) {
                    pa.setPostThoroughfareType(postType.getPreferredTypeName());
                    bPostType = true;
                    for (int cnt = 0; cnt < postType.getNumTokens(); ++cnt) {
                        mainAddrTokens.removeLast();
                    }
                    if (this.emptiedTokens(mainAddrTokens)) {
                        mainAddrTokens = origToks;
                        pa.setPostThoroughfareType(null);
                    }
                    if (origToks.size() != mainAddrTokens.size()) {
                        origToks = new StringWithTokens(mainAddrTokens.toString());
                    }
                }
            } else {
                pn = pa.getParsedAddressNumber();
                if (pn != null && pn.hasAddressSuffix()) {
                    String suffix = pn.getAddressSuffix();
                    if ("R".equalsIgnoreCase(pn.getAddressSuffix())) {
                        pa.setPreThoroughfareType("R");
                        pa.setAddressNumber(String.valueOf(pn.getAddressNumber()));
                    } else {
                        FRA_ThoroughfareTypes.KeyInfo key = FRA_ThoroughfareTypes.lookupByTypeName(suffix);
                        if (key != null) {
                            pa.setPreThoroughfareType(key.getPreferredTypeName());
                            pa.setAddressNumber(String.valueOf(pn.getAddressNumber()));
                        }
                    }
                }
            }
        }
        if (mainAddrTokens.size() > 1) {
            mainAddrTokens = this.parseUnitInfo((Address)pa, mainAddrTokens, false, true, !bPostType);
        }
        if (this.emptiedTokens(mainAddrTokens)) {
            mainAddrTokens = origToks;
            pa.setUnitType(null);
            pa.setUnitValue(null);
        }
        if (pa.getParsedAddressNumber() == null && pa.getUnitValue() != null && StringUtilities.isNumeric((String)pa.getUnitValue()) && (pa.getUnitType() == null || "N".equalsIgnoreCase(pa.getUnitType()))) {
            pa.setAddressNumber(pa.getUnitValue());
            pa.setUnitType(null);
            pa.setUnitValue(null);
        }
        if (origToks.size() != mainAddrTokens.size()) {
            origToks = new StringWithTokens(mainAddrTokens.toString());
        }
        if (mainAddrTokens.size() > 1 && (postType == null || preType != null) && FRA_Directionals.isDirectional(testDir = mainAddrTokens.getLastToken())) {
            String abb = FRA_Directionals.getAbbreviation(testDir);
            pa.setPostDirectional(abb);
            mainAddrTokens.removeLast();
            boolean bCompoundDir = false;
            if ((abb.equalsIgnoreCase("E") || abb.equalsIgnoreCase("O")) && FRA_Directionals.isDirectional(testDir = mainAddrTokens.getLastToken())) {
                bCompoundDir = true;
                StringBuilder sb = new StringBuilder(FRA_Directionals.getAbbreviation(testDir));
                sb.append(abb);
                testDir = sb.toString();
                if (FRA_Directionals.isDirectional(testDir)) {
                    pa.setPostDirectional(testDir);
                    mainAddrTokens.removeLast();
                }
            }
            if (this.emptiedTokens(mainAddrTokens)) {
                mainAddrTokens = origToks;
                pa.setPostDirectional(null);
            }
            if (origToks.size() != mainAddrTokens.size()) {
                origToks = new StringWithTokens(mainAddrTokens.toString());
            }
        }
        if (preType == null && mainAddrTokens.size() != 0 && postType == null && (postType = m_tfareTypes.findStreetType(mainAddrTokens, false)) != null && postType.foundAtEnd()) {
            pa.setPostThoroughfareType(postType.getPreferredTypeName());
            for (int cnt = 0; cnt < postType.getNumTokens(); ++cnt) {
                mainAddrTokens.removeLast();
            }
            if (this.emptiedTokens(mainAddrTokens)) {
                mainAddrTokens = origToks;
                pa.setPostThoroughfareType(null);
            }
        }
        if (mainAddrTokens.size() > 1 && pa.getParsedAddressNumber() == null) {
            String tok = mainAddrTokens.getLastToken();
            if (!FRA_SingleLineComparatorUtils.stringContainsMonthNameToken(mainAddrTokens.toString())) {
                String prev;
                if (StringUtilities.isNumeric((String)tok)) {
                    if (mainAddrTokens.size() > 2) {
                        if (FRA_ParseMainAddressRule.isValidHouseNumber(mainAddrTokens.getToken(mainAddrTokens.size() - 2))) {
                            pa.setUnitValue(tok);
                            pa.setAddressNumber(mainAddrTokens.getToken(mainAddrTokens.size() - 2));
                            mainAddrTokens.removeLast();
                            mainAddrTokens.removeLast();
                        } else {
                            pa.setAddressNumber(tok);
                            mainAddrTokens.removeLast();
                        }
                    } else {
                        pa.setAddressNumber(tok);
                        mainAddrTokens.removeLast();
                    }
                } else if (tok.length() == 1 && mainAddrTokens.size() > 2 && StringUtilities.isNumeric((String)(prev = mainAddrTokens.getToken(mainAddrTokens.size() - 2)))) {
                    StringBuilder sb = new StringBuilder(prev);
                    sb.append(' ');
                    sb.append(tok);
                    pa.setAddressNumber(sb.toString());
                    mainAddrTokens.removeLast();
                    mainAddrTokens.removeLast();
                }
            }
        }
        if (mainAddrTokens.size() != 0) {
            String uppercasedMain = mainAddrTokens.toString();
            String uppercasedInput = FRA_Standardizer.removePunctuation(FRA_Standardizer.toUpperCaseWithoutAccents(inputMainAddress));
            int idx = uppercasedInput.indexOf(uppercasedMain);
            if (idx >= 0) {
                int test = idx + uppercasedMain.length();
                if (inputMainAddress.length() > test && inputMainAddress.charAt(test) != ' ') {
                    if ((test = inputMainAddress.indexOf(32, test)) == -1) {
                        test = idx + uppercasedMain.length() + 1;
                    }
                } else if (test > inputMainAddress.length()) {
                    test = inputMainAddress.length();
                }
                pa.setGenericField1(inputMainAddress.substring(idx, test));
            }
            pa.setMainAddress(this.createMainAddressString(mainAddrTokens));
            if (this.bpPN != null) {
                if (this.isCSBox) {
                    pa.getAdditionalFields().put(AddressImpl.KEY_POBOX, "CS");
                } else {
                    pa.getAdditionalFields().put(AddressImpl.KEY_POBOX, "BP");
                }
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX_NUMBER, this.bpPN.getCombinedAddressNumber());
                if (pa.getAddressNumber() == null && this.bpHnrPossibleStreetHnr && !StringUtilities.isEmpty((String)pa.getMainAddress())) {
                    pa.setAddressNumber(this.bpPN);
                }
            }
            if (this.cedexPN != null) {
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2, "CEDEX");
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2_NUMBER, this.cedexPN.getCombinedAddressNumber());
                if (pa.getAddressNumber() == null && this.cedexHnrPossibleStreetHnr && !this.bpHnrPossibleStreetHnr && !StringUtilities.isEmpty((String)pa.getMainAddress())) {
                    pa.setAddressNumber(this.cedexPN);
                }
            }
        }
        this.copyFields(inParsedAddress, (Address)pa);
    }

    private boolean emptiedTokens(StringWithTokens list) {
        if (list.isEmpty()) {
            return true;
        }
        String remaining = FRA_Standardizer.removeCommonWords(list.toString());
        if (StringUtilities.isEmpty((String)remaining)) {
            return true;
        }
        return "D".equalsIgnoreCase(remaining) || "L".equalsIgnoreCase(remaining);
    }

    private boolean getHouseNumber(Address pa, StringWithTokens list, IConstraints constraints) {
        StringBuffer houseNum = new StringBuffer();
        if (list == null || list.size() == 0) {
            return false;
        }
        boolean bFoundAtStart = true;
        boolean bAbbreviatedHouseNumber = false;
        String s = this.stripHouseNumberFromStart(list, constraints);
        if (s != null) {
            houseNum.append(s);
            if (!s.equals(list.getFirstToken())) {
                bAbbreviatedHouseNumber = true;
            }
            list.removeFirst();
        } else {
            bFoundAtStart = false;
        }
        if (list.size() != 0) {
            String s1;
            String token = list.getFirstToken();
            if ("1/2".equals(token) || "1/4".equals(token) || "3/4".equals(token)) {
                houseNum.append(" ");
                houseNum.append(token);
                list.removeFirst();
            } else if (bAbbreviatedHouseNumber && (s1 = this.stripHouseNumberFromStart(list, constraints)) != null && !s1.equals(token) && StringUtilities.isNumeric((String)s1)) {
                int firstNum = 0;
                int secondNum = 0;
                try {
                    firstNum = Integer.parseInt(houseNum.toString());
                    secondNum = Integer.parseInt(s1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (firstNum >= 10 && firstNum % 10 == 0 && secondNum <= 9) {
                    houseNum = new StringBuffer(String.valueOf(firstNum + secondNum));
                    list.removeFirst();
                }
            }
        }
        if (bFoundAtStart) {
            pa.setAddressNumber(houseNum.toString());
        }
        return bFoundAtStart;
    }

    private String createMainAddressString(StringWithTokens listOfTokens) {
        return FRA_Standardizer.standardizeString(listOfTokens.toString());
    }

    private StringWithTokens findSpecialAddressFormats(Address pa, StringWithTokens mainAddrTokens) {
        String checked = FRA_Standardizer.standardizePostbox(mainAddrTokens.toString());
        if (StringUtilities.isEmpty((String)checked)) {
            return mainAddrTokens;
        }
        int idx = checked.indexOf("BP");
        if (idx >= 0) {
            mainAddrTokens = this.saveAndRemoveBPorCEDEX(pa, new StringWithTokens(checked), "BP", idx);
            checked = mainAddrTokens.toString();
        }
        if ((idx = checked.indexOf("CEDEX")) >= 0) {
            mainAddrTokens = this.saveAndRemoveBPorCEDEX(pa, new StringWithTokens(checked), "CEDEX", idx);
        }
        if ((idx = checked.indexOf("CS")) >= 0) {
            mainAddrTokens = this.saveAndRemoveBPorCEDEX(pa, new StringWithTokens(checked), "CS", idx);
        }
        if (mainAddrTokens.size() == 0 && this.bpPN != null) {
            if (this.isCSBox) {
                pa.setMainAddress("CS");
            } else {
                pa.setMainAddress("BP");
            }
            pa.setAddressNumber(this.bpPN);
            if (this.cedexPN != null) {
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2, "CEDEX");
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2_NUMBER, this.cedexPN.getCombinedAddressNumber());
            }
        } else if (mainAddrTokens.size() == 0 && this.cedexPN != null) {
            pa.setMainAddress("CEDEX");
            pa.setAddressNumber(this.cedexPN);
        }
        return mainAddrTokens;
    }

    private StringWithTokens removeBPorCEDEX(Address pa, StringWithTokens mainAddrTokens, String keyToken, int keyTokenIdx) {
        if (keyTokenIdx < 0) {
            return mainAddrTokens;
        }
        if (keyTokenIdx == 0) {
            String tok = mainAddrTokens.getFirstToken();
            if (keyToken.equalsIgnoreCase(tok)) {
                mainAddrTokens.removeFirst();
                if (!mainAddrTokens.isEmpty() && StringUtilities.hasNumeric((String)mainAddrTokens.getFirstToken())) {
                    String poBoxOrAddrNumber = mainAddrTokens.removeFirst();
                    if (poBoxOrAddrNumber.length() > 1 && poBoxOrAddrNumber.charAt(0) == '#') {
                        pa.setAddressNumber(poBoxOrAddrNumber.substring(1));
                    } else {
                        pa.setAddressNumber(poBoxOrAddrNumber);
                    }
                }
            } else if (StringUtilities.isNumeric((String)tok.substring(keyToken.length()))) {
                mainAddrTokens.removeFirst();
            }
            if (mainAddrTokens.isEmpty()) {
                pa.setMainAddress(keyToken);
                pa.setPreThoroughfareType(null);
                pa.setUnitType(null);
                pa.setUnitValue(null);
                pa.setPostThoroughfareType(null);
            }
            return mainAddrTokens;
        }
        for (int i = mainAddrTokens.size() - 1; i > 0; --i) {
            String tok = mainAddrTokens.getToken(i);
            if (!tok.startsWith(keyToken) || tok.length() != keyToken.length() && !StringUtilities.isNumeric((String)tok.substring(keyToken.length()))) continue;
            mainAddrTokens.remove(i);
            if (tok.length() != keyToken.length() || i >= mainAddrTokens.size() || !StringUtilities.isNumeric((String)(tok = mainAddrTokens.getToken(i)))) break;
            mainAddrTokens.remove(i);
            break;
        }
        return mainAddrTokens;
    }

    private void doSaveBP_CedexHnr(String key, String addrNum) {
        if (key == null || addrNum == null) {
            return;
        }
        if (key.equals("BP") || key.equals("CS")) {
            this.bpPN = addrNum.length() > 1 && addrNum.charAt(0) == '#' ? new ParsedNumber(addrNum.substring(1)) : new ParsedNumber(addrNum);
        } else if (key.equals("CEDEX")) {
            this.cedexPN = addrNum.length() > 1 && addrNum.charAt(0) == '#' ? new ParsedNumber(addrNum.substring(1)) : new ParsedNumber(addrNum);
        }
    }

    protected StringWithTokens saveAndRemoveBPorCEDEX(Address pa, StringWithTokens mainAddrTokens, String keyToken, int keyTokenIdx) {
        if (keyTokenIdx < 0) {
            return mainAddrTokens;
        }
        if (keyTokenIdx == 0) {
            String tok = mainAddrTokens.getFirstToken();
            if (keyToken.equalsIgnoreCase(tok)) {
                mainAddrTokens.removeFirst();
                if (!mainAddrTokens.isEmpty() && StringUtilities.hasNumeric((String)mainAddrTokens.getFirstToken())) {
                    String poBoxOrAddrNumber = mainAddrTokens.removeFirst();
                    this.doSaveBP_CedexHnr(keyToken, poBoxOrAddrNumber);
                    if ("BP".equals(keyToken)) {
                        this.bpHnrPossibleStreetHnr = true;
                    } else if ("CS".equals(keyToken)) {
                        this.bpHnrPossibleStreetHnr = true;
                        this.isCSBox = true;
                    } else if (!this.bpHnrPossibleStreetHnr && "CEDEX".equals(keyToken)) {
                        this.cedexHnrPossibleStreetHnr = true;
                    }
                }
            } else if (StringUtilities.isNumeric((String)tok.substring(keyToken.length()))) {
                mainAddrTokens.removeFirst();
            }
            if (mainAddrTokens.isEmpty()) {
                pa.setMainAddress(keyToken);
                pa.setPreThoroughfareType(null);
                pa.setUnitType(null);
                pa.setUnitValue(null);
                pa.setPostThoroughfareType(null);
            }
            return mainAddrTokens;
        }
        for (int i = mainAddrTokens.size() - 1; i > 0; --i) {
            String tok = mainAddrTokens.getToken(i);
            if (!tok.startsWith(keyToken) || tok.length() != keyToken.length() && !StringUtilities.isNumeric((String)tok.substring(keyToken.length()))) continue;
            mainAddrTokens.remove(i);
            if (tok.length() != keyToken.length() || i >= mainAddrTokens.size() || !StringUtilities.isNumeric((String)(tok = mainAddrTokens.getToken(i)))) break;
            this.doSaveBP_CedexHnr(keyToken, tok);
            mainAddrTokens.remove(i);
            if (!keyToken.equals("CS")) break;
            this.isCSBox = true;
            break;
        }
        return mainAddrTokens;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringWithTokens parseUnitInfo(Address pa, StringWithTokens tokens, boolean okayToPullFromFront, boolean checkForEmptyMainAddress, boolean bOkayToPullFromEnd) {
        String initialAddress = tokens.toString();
        String unitType = null;
        String unitValue = null;
        FRA_UnitType m_unitType = null;
        boolean foundUnit = false;
        boolean splitToken = false;
        if (bOkayToPullFromEnd) {
            String secondToLastToken = null;
            String lastToken = tokens.getLastToken();
            if (lastToken.length() > 1 && lastToken.charAt(0) == '#') {
                secondToLastToken = lastToken.substring(0, 1);
                lastToken = lastToken.substring(1);
                splitToken = true;
                String thirdToLastToken = tokens.getToken(tokens.size() - 2);
                if (FRA_UnitTypes.getUnitType(thirdToLastToken) != null) {
                    secondToLastToken = thirdToLastToken;
                    splitToken = false;
                }
            } else if (lastToken.length() > 3) {
                String[] validSeparators = new String[]{".#", "#", "."};
                for (int i = 0; i < validSeparators.length; ++i) {
                    String tmp;
                    int sepPos = lastToken.indexOf(validSeparators[i]);
                    if (sepPos == -1 || FRA_UnitTypes.getUnitType(tmp = lastToken.substring(0, sepPos)) == null) continue;
                    secondToLastToken = tmp;
                    lastToken = lastToken.substring(sepPos + validSeparators[i].length());
                    splitToken = true;
                    break;
                }
            } else if (this.testIsBisOrTer(lastToken)) {
                tokens.removeLast();
                return tokens;
            }
            if (secondToLastToken == null && tokens.size() > 1) {
                secondToLastToken = tokens.getToken(tokens.size() - 2);
            }
            if (secondToLastToken != null && tokens.size() > 2 && secondToLastToken.equalsIgnoreCase("NUMERO")) {
                boolean bFoundType = false;
                boolean bFoundUnitType = false;
                String thirdToLastToken = tokens.getToken(tokens.size() - 3);
                tokens.remove(tokens.size() - 2);
                if (thirdToLastToken != null) {
                    FRA_ThoroughfareTypes.KeyInfo canSt = FRA_ThoroughfareTypes.lookupByPreferredName(thirdToLastToken);
                    if (canSt == null) {
                        canSt = FRA_ThoroughfareTypes.lookupByTypeName(thirdToLastToken);
                    }
                    if (canSt != null) {
                        bFoundType = true;
                    } else {
                        FRA_UnitType canType = FRA_UnitTypes.getUnitType(thirdToLastToken);
                        if (canType != null) {
                            bFoundUnitType = true;
                        }
                    }
                }
                if (bFoundType) {
                    tokens.insert(tokens.size() - 1, "#");
                }
                if (bFoundType || bFoundUnitType) {
                    secondToLastToken = tokens.getToken(tokens.size() - 2);
                }
            }
            if (secondToLastToken != null) {
                m_unitType = FRA_UnitTypes.getUnitType(secondToLastToken);
                if (m_unitType != null) {
                    if (tokens.size() == 3 && FRA_ThoroughfareTypes.lookupByTypeName(tokens.getFirstToken()) != null && (lastToken == null || lastToken.length() > 2 && !Character.isDigit(lastToken.charAt(0)))) {
                        return tokens;
                    }
                    if (!"CZ".equalsIgnoreCase(m_unitType.getAbbreviation()) && lastToken.length() > 1 && !StringUtilities.hasNumeric((String)lastToken)) {
                        return tokens;
                    }
                    foundUnit = true;
                    unitType = m_unitType.getAbbreviation();
                    unitValue = lastToken;
                    tokens.removeLast();
                    if (!splitToken) {
                        tokens.removeLast();
                    }
                } else {
                    m_unitType = FRA_UnitTypes.getUnitType(lastToken);
                    if (m_unitType != null && !m_unitType.mustHaveUnitValue()) {
                        foundUnit = true;
                        unitType = m_unitType.getAbbreviation();
                        tokens.removeLast();
                    } else if (m_unitType != null && ("FL".equalsIgnoreCase(m_unitType.getAbbreviation()) || "\u00c9TAGE".equalsIgnoreCase(m_unitType.getAbbreviation())) && Character.isDigit(secondToLastToken.charAt(0))) {
                        StringBuffer buf = new StringBuffer();
                        int len = secondToLastToken.length();
                        for (int i = 0; i < len && Character.isDigit(secondToLastToken.charAt(i)); ++i) {
                            buf.append(secondToLastToken.charAt(i));
                        }
                        foundUnit = true;
                        unitType = m_unitType.getAbbreviation();
                        unitValue = buf.toString();
                        tokens.removeLast();
                        tokens.removeLast();
                    } else if (m_unitType == null && StringUtilities.isNumeric((String)lastToken) && lastToken.length() < 4) {
                        foundUnit = true;
                        unitValue = lastToken;
                        unitType = null;
                        tokens.removeLast();
                    }
                }
            } else {
                m_unitType = FRA_UnitTypes.getUnitType(lastToken);
                if (m_unitType != null && !m_unitType.mustHaveUnitValue()) {
                    foundUnit = true;
                    unitType = m_unitType.getAbbreviation();
                    tokens.removeLast();
                }
            }
        }
        if (!foundUnit && okayToPullFromFront) {
            splitToken = false;
            String secondToken = null;
            String firstToken = tokens.getFirstToken();
            if (firstToken.length() > 1 && firstToken.charAt(0) == '#') {
                secondToken = firstToken.substring(1);
                firstToken = firstToken.substring(0, 1);
                splitToken = true;
            } else if (tokens.size() > 1) {
                secondToken = tokens.getToken(1);
            }
            if (secondToken != null) {
                m_unitType = FRA_UnitTypes.getUnitType(firstToken);
                if (m_unitType != null && m_unitType.mustHaveUnitValue()) {
                    foundUnit = true;
                    unitType = m_unitType.getAbbreviation();
                    unitValue = secondToken;
                    tokens.removeFirst();
                    if (!splitToken) {
                        tokens.removeFirst();
                    }
                }
            } else {
                m_unitType = FRA_UnitTypes.getUnitType(firstToken);
                if (m_unitType != null && !m_unitType.mustHaveUnitValue()) {
                    foundUnit = true;
                    unitType = m_unitType.getAbbreviation();
                    tokens.removeFirst();
                }
            }
        }
        if (checkForEmptyMainAddress && foundUnit && tokens.size() <= 1 && (tokens.size() == 0 || pa.getAddressNumber() == null && !"#".equals(unitType) && FRA_ParseMainAddressRule.isValidHouseNumber(tokens.getFirstToken()))) {
            return new StringWithTokens(initialAddress, m_mainAddrTokenSeparators);
        }
        if (foundUnit) {
            if (pa.getUnitType() != null && pa.getUnitValue() != null) {
                if (!pa.getUnitType().equals("#")) return new StringWithTokens(initialAddress, m_mainAddrTokenSeparators);
                pa.setUnitValue(unitValue);
                pa.setUnitType(unitType);
            } else {
                pa.setUnitType(unitType);
                pa.setUnitValue(unitValue);
            }
        }
        if (!"-".equals(tokens.getLastToken())) return tokens;
        tokens.removeLast();
        return tokens;
    }

    private String stripHouseNumberFromStart(StringWithTokens list, IConstraints constraints) {
        if (list.size() < 2) {
            return null;
        }
        String addressNumber = list.getFirstToken();
        String nextToken = list.getToken(1);
        ParsedNumber pn = new ParsedNumber(addressNumber);
        if (!pn.getAddressNumberExists()) {
            if (pn.isFractionalTrailer()) {
                return pn.getCombinedAddressNumber();
            }
            return null;
        }
        if (pn.isPureNumeric() && m_compoundHouseNumberSeparators.contains(nextToken) && list.size() > 3) {
            String token3 = list.getToken(2);
            ParsedNumber pn2 = new ParsedNumber(token3);
            if (pn2.isPureNumeric()) {
                StringBuffer numBuf = new StringBuffer();
                numBuf.append(pn.getCombinedAddressNumber());
                numBuf.append(' ');
                numBuf.append(nextToken);
                numBuf.append(' ');
                numBuf.append(token3);
                list.remove(1);
                list.remove(1);
                return numBuf.toString();
            }
            if ("A".equalsIgnoreCase(nextToken)) {
                pn.setAddressSuffix(nextToken);
                list.remove(1);
                return pn.getCombinedAddressNumber();
            }
            return pn.getCombinedAddressNumber();
        }
        if (pn.hasAddressSuffix()) {
            String end = pn.getAddressSuffix();
            if (this.testIsBisOrTer(end)) {
                pn.setAddressSuffix("");
                return pn.getCombinedAddressNumber();
            }
            return pn.getCombinedAddressNumber();
        }
        if (pn.hasNumberSeparator() && m_compoundHouseNumberSeparators.contains(pn.getNumberSeparator())) {
            return pn.getCombinedAddressNumber();
        }
        if (pn.isPureNumeric() && (list.size() <= 2 || !"L".equalsIgnoreCase(nextToken) || "AEIOUH".indexOf(list.getToken(2).charAt(0)) < 0)) {
            if (nextToken.length() == 1) {
                StringBuilder sb = new StringBuilder(addressNumber);
                sb.append(' ');
                sb.append(nextToken);
                pn = new ParsedNumber(sb.toString());
                list.remove(1);
                return pn.getCombinedAddressNumber();
            }
            if (this.testIsBisOrTer(nextToken)) {
                list.remove(1);
                return pn.getCombinedAddressNumber();
            }
            if (StringUtilities.isNumeric((String)nextToken)) {
                StringBuilder sb = new StringBuilder(addressNumber);
                sb.append(' ');
                sb.append(nextToken);
                pn = new ParsedNumber(sb.toString());
                list.remove(1);
                return pn.getCombinedAddressNumber();
            }
        }
        return pn.getCombinedAddressNumber();
    }

    private boolean testIsBisOrTer(String token) {
        if (token.length() > 3) {
            return false;
        }
        return token.equalsIgnoreCase("BIS") || token.equalsIgnoreCase("TER") || token.equalsIgnoreCase("BI") || token.equalsIgnoreCase("TE");
    }

    private String getFullAddressString(Address addr) {
        String inStr;
        StringBuffer builtBuf = new StringBuffer();
        boolean bChanged = false;
        ParsedNumber inNum = addr.getParsedAddressNumber();
        if (inNum != null) {
            builtBuf.append(inNum.getCombinedAddressNumber());
            bChanged = true;
        }
        if ((inStr = addr.getPreDirectional()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if ((inStr = addr.getPreThoroughfareType()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if ((inStr = addr.getMainAddress()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
        }
        if ((inStr = addr.getPostThoroughfareType()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if ((inStr = addr.getPostDirectional()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if (bChanged) {
            return builtBuf.toString().toUpperCase();
        }
        return null;
    }

    private void RemoveBadChars(Address pa) {
        String[] Addresses = new String[2];
        StringBuffer[] newAddrs = new StringBuffer[2];
        Addresses[0] = pa.getMainAddress();
        Addresses[1] = pa.getGenericField1();
        for (int i = 0; i < 2; ++i) {
            if (Addresses[i] == null) continue;
            block4: for (int j = 0; j < Addresses[i].length(); ++j) {
                char thischar = Addresses[i].charAt(j);
                int ttype = Character.getType(thischar);
                switch (ttype) {
                    case 0: 
                    case 12: 
                    case 15: 
                    case 26: {
                        if (newAddrs[i] != null) {
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        newAddrs[i] = new StringBuffer();
                        newAddrs[i].append(' ');
                        continue block4;
                    }
                    default: {
                        boolean isValidChar;
                        boolean bl = isValidChar = thischar != '\"';
                        if (newAddrs[i] == null) {
                            newAddrs[i] = new StringBuffer("");
                            if (isValidChar) {
                                newAddrs[i].append(thischar);
                                continue block4;
                            }
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        if (isValidChar) {
                            newAddrs[i].append(thischar);
                            continue block4;
                        }
                        newAddrs[i].append(' ');
                    }
                }
            }
            if (i == 0) {
                pa.setMainAddress(newAddrs[0].toString().trim());
                continue;
            }
            pa.setGenericField1(newAddrs[1].toString().trim());
        }
    }

    private void copyFields(Address to, Address from) {
        to.setAddressNumber(from.getAddressNumber());
        to.setGenericField1(from.getGenericField1());
        to.setGenericField2(from.getGenericField2());
        to.setGenericField3(from.getGenericField3());
        to.setGenericField4(from.getGenericField4());
        to.setMainAddress(from.getMainAddress());
        to.setPreAddress(from.getPreAddress());
        to.setPreDirectional(from.getPreDirectional());
        to.setPreThoroughfareType(from.getPreThoroughfareType());
        to.setPostAddress(from.getPostAddress());
        to.setPostDirectional(from.getPostDirectional());
        to.setPostThoroughfareType(from.getPostThoroughfareType());
        to.setUnitType(from.getUnitType());
        to.setUnitValue(from.getUnitValue());
        to.getAdditionalFields().clear();
        to.getAdditionalFields().putAll(from.getAdditionalFields());
    }

    public static boolean isValidHouseNumber(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen > 1 && FRA_ParseMainAddressRule.isAlpha(hnr.charAt(hnrLen - 1))) {
            return FRA_ParseMainAddressRule.isValidNumberFormat(hnr.substring(0, hnrLen - 1), hnrLen - 1);
        }
        return FRA_ParseMainAddressRule.isValidNumberFormat(hnr, hnrLen);
    }

    public static boolean isValidNumberFormat(String num, int len) {
        boolean bRc = true;
        if (num == null || num.trim().length() == 0) {
            return false;
        }
        if (num.trim().length() == len) {
            for (int i = 0; i < num.length(); ++i) {
                char ch = num.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                bRc = false;
                break;
            }
        } else {
            bRc = false;
        }
        return bRc;
    }

    public static boolean isAlpha(char ch) {
        char c = Character.toUpperCase(ch);
        return c >= 'A' && c <= 'Z';
    }

    static {
        String[] compounds = new String[]{"/", "-", "ET", "A", "\u00c0"};
        m_compoundHouseNumberSeparators = new HashSet(compounds.length);
        for (int i = 0; i < compounds.length; ++i) {
            m_compoundHouseNumberSeparators.add(compounds[i]);
        }
    }
}

