/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class FRAPreferHouseBeforeStreetRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasStreetAfterHouse1 = this.hasStreetAfterHouse(o1);
        boolean hasStreetAfterHouse2 = this.hasStreetAfterHouse(o2);
        if (hasStreetAfterHouse1 && !hasStreetAfterHouse2) {
            return -1;
        }
        if (!hasStreetAfterHouse1 && hasStreetAfterHouse2) {
            return 1;
        }
        return 0;
    }

    private boolean hasStreetAfterHouse(IAddressParsing parsing) {
        String house = parsing.getParse()[0].getAddressNumber();
        if (StringUtilities.isEmpty((String)house)) {
            return false;
        }
        String main = parsing.getParse()[0].getMainAddress();
        if (StringUtilities.isEmpty((String)main)) {
            return false;
        }
        StringBuilder sb = new StringBuilder(house);
        sb.append(' ');
        String pre = parsing.getParse()[0].getPreThoroughfareType();
        if (!StringUtilities.isEmpty((String)pre)) {
            sb.append(pre);
            sb.append(' ');
        }
        sb.append(main);
        return FRA_Standardizer.standardizeString(parsing.getSplit().getAddress().getMainAddress()).startsWith(sb.toString());
    }
}

