/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class FRARejectNumericOnlyInStreetNameRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasNumericStreetAndCityAndRegion1 = this.hasNumericStreetAndCityAndRegion(o1);
        boolean hasNumericStreetAndCityAndRegion2 = this.hasNumericStreetAndCityAndRegion(o2);
        if (hasNumericStreetAndCityAndRegion1 && !hasNumericStreetAndCityAndRegion2) {
            return 1;
        }
        if (!hasNumericStreetAndCityAndRegion1 && hasNumericStreetAndCityAndRegion2) {
            return -1;
        }
        return 0;
    }

    private boolean hasNumericStreetAndCityAndRegion(IAddressParsing parsing) {
        Address addr = parsing.getParse()[0];
        if (addr.getAreaName1() == null || addr.getAreaName3() == null || addr.getAddressNumber() != null) {
            return false;
        }
        return StringUtilities.isNumeric((String)addr.getMainAddress());
    }
}

