/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class FRA_SingleLineComparatorUtils {
    private static final String PLACEHOLDER = "PLACEHOLDER";
    private static final List<String> badInitialCityArticles;
    private static final List<String> badInitialStreetArticles;
    private static final List<String> commonStreetTypes;
    private static final List<String> commonCompoundStreetTypeLeadIns;
    private static final List<String> validRegions;
    private static final List<String> saints;
    private static final List<String> months;
    private static final List<String> citiesWithArrondissements;
    private static final List<String> largeCities;
    private static final List<String> preferredPreTypes;
    private static final FRA_ThoroughfareTypes m_tfareTypes;

    public static String getStartingToken(String str) {
        int idx;
        if (!StringUtilities.isEmpty((String)str) && (idx = str.indexOf(32)) > 0) {
            return str.substring(0, idx);
        }
        return str;
    }

    public static String getEndingToken(String str) {
        int idx;
        if (!StringUtilities.isEmpty((String)str) && (idx = str.lastIndexOf(32)) > 0) {
            return str.substring(idx + 1);
        }
        return str;
    }

    public static boolean tokenIsArticle(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        StringBuilder sb = new StringBuilder(PLACEHOLDER);
        sb.append(' ');
        sb.append(str);
        String test = FRA_Standardizer.standardizeString(sb.toString());
        return PLACEHOLDER.equalsIgnoreCase(test);
    }

    static boolean tokenIsRestrictedCityArticle(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        int idx = str.indexOf(32);
        if (idx > 0) {
            str = str.substring(0, idx);
        }
        return badInitialCityArticles.contains(FRA_Standardizer.toUpperCaseWithoutAccents(str));
    }

    static boolean tokenIsRestrictedStreetArticle(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        int idx = str.indexOf(32);
        if (idx > 0) {
            str = str.substring(0, idx);
        }
        return badInitialStreetArticles.contains(FRA_Standardizer.toUpperCaseWithoutAccents(str));
    }

    static boolean stringContainsCommonTypeToken(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(str);
        boolean bHadLeadIn = false;
        boolean bFirst = true;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (bFirst && commonCompoundStreetTypeLeadIns.contains(tok)) {
                bHadLeadIn = true;
                bFirst = false;
                continue;
            }
            if (!bHadLeadIn && commonStreetTypes.contains(tok)) {
                return true;
            }
            bHadLeadIn = false;
        }
        return false;
    }

    static boolean stringContainsValidStandardizedRegionNameTokens(String main) {
        for (String region : validRegions) {
            if (!main.contains(region)) continue;
            return true;
        }
        return false;
    }

    static boolean stringEqualsValidStandardizedRegionName(String str) {
        return validRegions.contains(str);
    }

    static boolean tokenIsStandardizedSaint(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        return saints.contains(str);
    }

    static boolean tokenIsNonStandardizedSaint(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        return saints.contains(FRA_Standardizer.standardizeString(str));
    }

    static int countStandardizedSaintTokensInString(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return 0;
        }
        int count = 0;
        StringTokenizer st = new StringTokenizer(FRA_Standardizer.standardizeString(str));
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!saints.contains(tok)) continue;
            ++count;
        }
        return count;
    }

    public static boolean stringContainsMonthNameToken(String str) {
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            if (!months.contains(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    static boolean stringEqualsCityUsingArrondissements(String str) {
        return str != null && citiesWithArrondissements.contains(str);
    }

    static boolean stringEqualsMajorCity(String str) {
        return str != null && largeCities.contains(str);
    }

    static boolean stringEqualsPreferredPreType(String str) {
        return str != null && preferredPreTypes.contains(str);
    }

    static boolean tokenIsProperNameIndicator(String str) {
        if (str != null) {
            return FRA_ScoringHelper.isCommonNamedStreetPrefix(str);
        }
        return false;
    }

    static boolean stringStartsWithPreTypeIndicator(String str) {
        if (str == null) {
            return false;
        }
        StringWithTokens toks = new StringWithTokens(str);
        if (StringUtilities.isNumeric((String)toks.getFirstToken())) {
            toks.removeFirst();
        }
        return commonStreetTypes.contains(toks.getFirstToken());
    }

    static String stripArrondissement(String str) {
        if (str != null && StringUtilities.hasNumeric((String)str)) {
            StringTokenizer st = new StringTokenizer(str);
            if (st.countTokens() != 2) {
                return str;
            }
            String tok = st.nextToken();
            if (StringUtilities.hasNumeric((String)tok)) {
                tok = st.nextToken();
            }
            return tok;
        }
        return str;
    }

    static {
        m_tfareTypes = new FRA_ThoroughfareTypes();
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("SUR");
        temp.add("DE");
        temp.add("ET");
        badInitialCityArticles = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("SUR");
        temp.add("ET");
        badInitialStreetArticles = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("R");
        preferredPreTypes = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("PARIS");
        temp.add("MARSEILLES");
        temp.add("LEON");
        citiesWithArrondissements = Collections.unmodifiableList(temp);
        largeCities = Collections.unmodifiableList(temp);
        String[] monthNames = new String[]{"JANVIER", "FEVRIER", "MARS", "AVRIL", "MAI", "JUIN", "JUILLET", "AOUT", "SEPTEMBRE", "OCTOBRE", "NOVEMBRE", "DECEMBRE", "JAN", "FEV", "MAR", "AVR", "SEP", "OCT", "NOV", "DEC,", "JANV", "FEVR", "JUIL", "SEPT"};
        temp = new ArrayList();
        for (String month : monthNames) {
            temp.add(month);
        }
        months = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("SAINT");
        temp.add("SAINTE");
        temp.add("ST");
        temp.add("STE");
        saints = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("ALSACE");
        temp.add("AQUITAINE");
        temp.add("AUVERGNE");
        temp.add("BASSE NORMANDIE");
        temp.add("BOURGOGNE");
        temp.add("BRETAGNE");
        temp.add("CENTRE");
        temp.add("CHAMPAGNE ARDENNE");
        temp.add("CORSE");
        temp.add("FRANCHE COMTE");
        temp.add("HAUTE NORMANDIE");
        temp.add("ILE FRANCE");
        temp.add("LANGUEDOC ROUSSILLON");
        temp.add("LIMOUSIN");
        temp.add("LORRAINE");
        temp.add("MIDI PYRENEES");
        temp.add("NORD PAS CALAIS");
        temp.add("PAYS LOIRE");
        temp.add("PICARDIE");
        temp.add("POITOU CHARENTES");
        temp.add("PROVENCE ALPES COTE AZUR");
        temp.add("RHONE ALPES");
        validRegions = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("RUE");
        temp.add("AVENUE");
        temp.add("CHEMIN");
        commonStreetTypes = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("GRAND");
        temp.add("GRANDE");
        temp.add("VIEUX");
        temp.add("PETIT");
        temp.add("PETITE");
        temp.add("ANCIENNE");
        temp.add("ANCIEN");
        commonCompoundStreetTypeLeadIns = Collections.unmodifiableList(temp);
    }
}

