/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.LIE;

import com.mapinfo.mapmarker.CHE.CHE_Geocoder;
import com.mapinfo.mapmarker.CHE.CHE_SpecificHandler;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_DataManager;
import com.mapinfo.mapmarker.CHE.singleline.CHESingleLineParser;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;

public class LIEGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        LIEGeocodingFactory geocodingFactory = new LIEGeocodingFactory();
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)geocodingFactory, (ISingleLineParser)new CHESingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            CHE_DataManager data = new CHE_DataManager();
            data.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    private static class LIEGeocodingFactory
    implements IGeocoderFactory {
        private LIEGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            address.setGenericField4(String.valueOf(constraints.getGeocodeType()));
            return new CHE_Geocoder(CHE_SpecificHandler.buildHandler(address));
        }
    }
}

