/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.NZL.NZL_Geocoder;
import com.mapinfo.mapmarker.NZL.NZL_Handler;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_DataManager;
import com.mapinfo.mapmarker.NZL.singleline.NZL_SingleLineParser;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;

public class NZLGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        NZLGeocodingFactory geocodingFactory = new NZLGeocodingFactory();
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)geocodingFactory, (ISingleLineParser)new NZL_SingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            NZL_DataManager data = new NZL_DataManager();
            data.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    private static class NZLGeocodingFactory
    implements IGeocoderFactory {
        private NZLGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            return new NZL_Geocoder(NZL_Handler.buildHandler(address, constraints));
        }
    }
}

