/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZL_InternalCandidateAddress;
import com.mapinfo.mapmarker.NZL.NZL_InternalGeographicCandidate;
import com.mapinfo.mapmarker.NZL.NZL_InternalMatcherConstants;
import com.mapinfo.mapmarker.NZL.NZL_InternalPostalCandidate;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;

public class NZL_AddressFilter {
    private static double ADDITIONAL_FIELD_THRESHOLD = 0.75;
    private static double ADDRESS_THRESHOLD = 0.75;
    private static double PERFECT_ADDITIONAL_FIELD_THRESHOLD = 0.9;
    private static double PERFECT_ADDRESS_THRESHOLD = 0.956;
    private static double THRESHOLD = 0.9;
    private static double PERFECT_SCORE = 1.0;
    private static double PERFECT_GEOGRAPHIC_THRESHOLD = 0.88;
    private static double GEOGRAPHIC_THRESHOLD = 0.87;

    private NZL_AddressFilter() {
    }

    public static void filterAddresses(IConstraints constraints, GeocodeResult geocodeResult) {
        boolean removed;
        List candidates = constraints.getHandler().getMatchResults();
        if (candidates != null && candidates.size() != 0 && (removed = NZL_AddressFilter.maybeFilterStreetCandidates(constraints, candidates) | NZL_AddressFilter.maybeFilterPostalCandidates(candidates) | NZL_AddressFilter.maybeFilterGeographicCandidates(candidates))) {
            NZL_AddressFilter.countCandidates(candidates, geocodeResult);
            NZL_AddressFilter.countCloseMatches(candidates, geocodeResult);
        }
    }

    private static boolean maybeFilterStreetCandidates(IConstraints constraints, List candidates) {
        boolean removed = false;
        if (candidates.get(0) instanceof InternalCandidateAddress) {
            double combined;
            InternalCandidateAddress addr;
            double highest = 0.0;
            Iterator iter = candidates.iterator();
            while (iter.hasNext() && highest != PERFECT_SCORE) {
                InternalCandidateAddress addr2 = (InternalCandidateAddress)iter.next();
                double temp = addr2.getCombinedAdditionalFieldScore();
                if (!(temp > highest)) continue;
                highest = temp;
            }
            double threshold = highest == PERFECT_SCORE ? highest * PERFECT_ADDITIONAL_FIELD_THRESHOLD : highest * ADDITIONAL_FIELD_THRESHOLD;
            iter = candidates.iterator();
            while (iter.hasNext()) {
                addr = (InternalCandidateAddress)iter.next();
                combined = addr.getCombinedAdditionalFieldScore();
                if (!(combined > 0.0) || !(threshold > combined)) continue;
                InternalMatcherConstants imc = constraints.getHandler().getMatcherConstants().getStreetMatcherConstants();
                double exemptionCutOff = ((NZL_InternalMatcherConstants)imc).getExemptionCutOff();
                if (!(addr.getCombinedAddressScore() < exemptionCutOff)) continue;
                iter.remove();
                removed = true;
            }
            highest = 0.0;
            iter = candidates.iterator();
            while (iter.hasNext() && highest != PERFECT_SCORE) {
                addr = (InternalCandidateAddress)iter.next();
                double temp = addr.getCombinedAddressScore();
                if (!(temp > highest)) continue;
                highest = temp;
            }
            threshold = highest >= THRESHOLD ? highest * PERFECT_ADDRESS_THRESHOLD : highest * ADDRESS_THRESHOLD;
            iter = candidates.iterator();
            while (iter.hasNext()) {
                addr = (NZL_InternalCandidateAddress)((Object)iter.next());
                combined = addr.getCombinedAddressScore();
                if (!(combined > 0.0) || !(threshold > combined) || addr.isCloseMatch()) continue;
                iter.remove();
                removed = true;
            }
        } else if (candidates.get(0) instanceof InternalIntersectionCandidateAddress) {
            LinkedHashMap<DirectPosition, InternalIntersectionCandidateAddress> linkedMap = new LinkedHashMap<DirectPosition, InternalIntersectionCandidateAddress>(candidates.size());
            for (InternalIntersectionCandidateAddress interAddr : candidates) {
                DirectPosition location = interAddr.getIntersectionPoint();
                if (linkedMap.containsKey(location)) {
                    removed = true;
                    InternalIntersectionCandidateAddress oldInterAddr = (InternalIntersectionCandidateAddress)linkedMap.get(location);
                    if (!NZL_AddressFilter.promote(interAddr, oldInterAddr)) continue;
                    linkedMap.remove(location);
                    linkedMap.put(location, interAddr);
                    continue;
                }
                linkedMap.put(location, interAddr);
            }
            candidates.clear();
            candidates.addAll(linkedMap.values());
        }
        return removed;
    }

    private static boolean maybeFilterGeographicCandidates(List candidates) {
        boolean removedCandidate = false;
        if (candidates.get(0) instanceof InternalGeographicCandidate) {
            double bestGeographicCandidateScore = 0.0;
            double tempBestGeographicCandidateScore = 0.0;
            for (InternalGeographicCandidate geographicCandidate : candidates) {
                tempBestGeographicCandidateScore = geographicCandidate.getCombinedScore();
                if (!(tempBestGeographicCandidateScore > bestGeographicCandidateScore)) continue;
                bestGeographicCandidateScore = tempBestGeographicCandidateScore;
            }
            double threshold = bestGeographicCandidateScore >= 1.0 ? bestGeographicCandidateScore * PERFECT_GEOGRAPHIC_THRESHOLD : bestGeographicCandidateScore * GEOGRAPHIC_THRESHOLD;
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                InternalGeographicCandidate geographicCandidate = (InternalGeographicCandidate)iter.next();
                double candScore = geographicCandidate.getCombinedScore();
                if (!(candScore > 0.0) || !(candScore < threshold)) continue;
                iter.remove();
                removedCandidate = true;
            }
        }
        if (candidates.get(0) instanceof NZL_InternalGeographicCandidate) {
            ListIterator itr = candidates.listIterator();
            while (itr.hasNext()) {
                NZL_InternalGeographicCandidate geoCand = (NZL_InternalGeographicCandidate)((Object)itr.next());
                if (!NZL_AddressFilter.dupeGeoInList(geoCand, candidates)) continue;
                itr.remove();
                removedCandidate = true;
            }
        }
        return removedCandidate;
    }

    private static boolean dupeGeoInList(NZL_InternalGeographicCandidate geoCand, List candidates) {
        for (int i = 0; i < candidates.size(); ++i) {
            NZL_InternalGeographicCandidate testGeoCandidate = (NZL_InternalGeographicCandidate)((Object)candidates.get(i));
            if (testGeoCandidate == geoCand || !NZL_AddressFilter.equalStrings(testGeoCandidate.getAltAreaName1(), geoCand.getAltAreaName1()) || !NZL_AddressFilter.equalStrings(testGeoCandidate.getAreaName1(), geoCand.getAreaName1()) || !NZL_AddressFilter.equalStrings(testGeoCandidate.getAreaName2(), geoCand.getAreaName2()) || !NZL_AddressFilter.equalStrings(testGeoCandidate.getAreaName3(), geoCand.getAreaName3()) || !NZL_AddressFilter.equalStrings(testGeoCandidate.getAreaName4(), geoCand.getAreaName4()) || !NZL_AddressFilter.equalStrings(testGeoCandidate.getCountry(), geoCand.getCountry()) || testGeoCandidate.getPrecision() != geoCand.getPrecision() || !testGeoCandidate.getCentroid().equals((Object)geoCand.getCentroid()) || testGeoCandidate.getDictionaryPriority() > geoCand.getDictionaryPriority()) continue;
            return true;
        }
        return false;
    }

    private static boolean equalStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private static boolean maybeFilterPostalCandidates(List candidates) {
        boolean removedCandidate = false;
        if (candidates.get(0) instanceof NZL_InternalPostalCandidate) {
            ListIterator itr = candidates.listIterator();
            while (itr.hasNext()) {
                NZL_InternalPostalCandidate postalCandidate = (NZL_InternalPostalCandidate)((Object)itr.next());
                if (!NZL_AddressFilter.dupePostInList(postalCandidate, candidates)) continue;
                itr.remove();
                removedCandidate = true;
            }
        }
        return removedCandidate;
    }

    private static boolean dupePostInList(NZL_InternalPostalCandidate postalCandidate, List candidates) {
        for (int i = 0; i < candidates.size(); ++i) {
            NZL_InternalPostalCandidate testCand = (NZL_InternalPostalCandidate)((Object)candidates.get(i));
            if (testCand == postalCandidate || !NZL_AddressFilter.equalStrings(testCand.getAreaName1(), postalCandidate.getAreaName1()) || !NZL_AddressFilter.equalStrings(testCand.getAreaName2(), postalCandidate.getAreaName2()) || !NZL_AddressFilter.equalStrings(testCand.getAreaName3(), postalCandidate.getAreaName3()) || !NZL_AddressFilter.equalStrings(testCand.getAreaName4(), postalCandidate.getAreaName4()) || !NZL_AddressFilter.equalStrings(testCand.getCountry(), postalCandidate.getCountry()) || !NZL_AddressFilter.equalStrings(testCand.getPostCode1(), postalCandidate.getPostCode1()) || !testCand.getPoint().equals((Object)postalCandidate.getPoint()) || testCand.getDictionaryPriority() > postalCandidate.getDictionaryPriority()) continue;
            return true;
        }
        return false;
    }

    private static void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private static void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private static boolean promote(InternalIntersectionCandidateAddress srcAddr, InternalIntersectionCandidateAddress comparedAddr) {
        return NZL_AddressFilter.calculateSimpleScore(srcAddr) > NZL_AddressFilter.calculateSimpleScore(comparedAddr);
    }

    private static double calculateSimpleScore(InternalIntersectionCandidateAddress addr) {
        double score = 0.0;
        InternalCandidateAddress cand1 = addr.getCandidate1();
        InternalCandidateAddress cand2 = addr.getCandidate2();
        score += cand1.getAddressNumberScore();
        return score += cand2.getAddressNumberScore();
    }
}

