/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.NZL.parser.NZL_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class NZL_AddressUtils {
    private static final double CLOSE_MATCH_SCORE = 1.0;

    private NZL_AddressUtils() {
    }

    public static String getFormattedStreetAddress(Address addr, boolean bAppendAddressNumber) {
        NZL_ThoroughfareTypes.NZL_ThoroughfareType type;
        String outputTT;
        String delim = " \t\n\r\f";
        String streetName = addr.getGenericField4();
        String unitValue = addr.getUnitValue();
        String unitType = addr.getUnitType();
        String unitInfo = null;
        if (streetName != null) {
            String addressNum = addr.getAddressNumber();
            if (addressNum != null) {
                if (unitValue != null && !unitValue.equalsIgnoreCase("0")) {
                    unitInfo = unitType != null ? unitType + " " + unitValue : unitValue;
                }
                if (unitInfo != null) {
                    return unitInfo + " " + addressNum + " " + NZL_AddressUtils.toProperCase(streetName, delim);
                }
                return addressNum + " " + NZL_AddressUtils.toProperCase(streetName, delim);
            }
            return NZL_AddressUtils.toProperCase(streetName, delim);
        }
        StringBuffer str = new StringBuffer();
        if (addr.getUnitValue() != null && !addr.getUnitValue().equalsIgnoreCase("0")) {
            if (addr.getUnitType() != null) {
                str.append(addr.getUnitType());
                str.append(' ');
            }
            str.append(addr.getUnitValue());
            str.append(' ');
        }
        if (addr.getAddressNumber() != null && bAppendAddressNumber) {
            str.append(addr.getAddressNumber());
            str.append(" ");
        }
        if (addr.getPreDirectional() != null) {
            str.append(addr.getPreDirectional());
            str.append(" ");
        }
        if (addr.getPreThoroughfareType() != null) {
            outputTT = addr.getPreThoroughfareType();
            type = NZL_ThoroughfareTypes.getThoroughfareType(outputTT);
            if (type != null) {
                outputTT = type.getExpandedTypeName();
            }
            str.append(outputTT);
            str.append(" ");
        }
        if (addr.getPreAddress() != null) {
            str.append(addr.getPreAddress());
            str.append(" ");
        }
        if (addr.getMainAddress() != null) {
            str.append(addr.getMainAddress());
            str.append(" ");
        }
        if (addr.getPostAddress() != null) {
            str.append(addr.getPostAddress());
            str.append(" ");
        }
        if (addr.getPostThoroughfareType() != null) {
            outputTT = addr.getPostThoroughfareType();
            type = NZL_ThoroughfareTypes.getThoroughfareType(outputTT);
            if (type != null) {
                outputTT = type.getExpandedTypeName();
            }
            str.append(outputTT);
            str.append(" ");
        }
        if (addr.getPostDirectional() != null) {
            str.append(addr.getPostDirectional());
            str.append(" ");
        }
        return str.toString().trim();
    }

    public static String getFormattedPreAddress(Address addr) {
        String preMainCommon;
        String preAddrCommon;
        String preTT;
        HashMap fields = addr.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String preDir = addr.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((preTT = addr.getPreThoroughfareType()) != null) {
            buf.append(preTT);
            buf.append(' ');
        }
        if ((preAddrCommon = (String)fields.get("pre_addr_common")) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get("address.common.pre.main")) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        return buf.toString().trim();
    }

    public static boolean isPrefixAndSuffixCloseMatch(Address input, InternalCandidateAddress addr) {
        boolean postMatch;
        boolean isCloseMatch = true;
        boolean preMatch = NZL_AddressUtils.isEmpty(input.getPreAddress()) || addr.getPreAddressScore() == 1.0;
        boolean bl = postMatch = NZL_AddressUtils.isEmpty(input.getPostAddress()) || addr.getPostAddressScore() == 1.0;
        if (!preMatch || !postMatch) {
            isCloseMatch = false;
        }
        return isCloseMatch;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String toProperCase(String input, String delimiters) {
        if (input == null) {
            return null;
        }
        String output = "";
        StringTokenizer tokenizer = new StringTokenizer(input, delimiters);
        int pos = 0;
        while (tokenizer.hasMoreElements()) {
            char ch;
            String temp = tokenizer.nextToken();
            if (temp == null) continue;
            temp = temp.substring(0, 1).toUpperCase() + temp.substring(1);
            for (pos = output.length() + temp.length(); pos < input.length() && (ch = input.charAt(pos)) != '\u0000' && NZL_AddressUtils.isSpecialChar(ch, delimiters.toCharArray()); ++pos) {
                temp = temp + ch;
            }
            output = output + temp;
        }
        return output;
    }

    public static boolean isSpecialChar(char c, char[] excludeChars) {
        if (excludeChars == null || excludeChars.length == 0) {
            return false;
        }
        Arrays.sort(excludeChars);
        int index = Arrays.binarySearch(excludeChars, c);
        return index >= 0;
    }

    public static double extractDouble(String string) {
        if (string == null || string.length() == 0) {
            return -1.0;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!Character.isDigit(ch)) continue;
            sb.append(ch);
        }
        try {
            return new Double(sb.toString());
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }
}

