/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.IHandler;
import java.util.Locale;

public class NZL_Constraints
extends Constraints {
    private boolean isDataConstructionConstraint;
    private static final String RELAXED_MODE = "RelaxedMode";
    public static final String KEY_CONSIDER_AMPERSAND_AS_INTERSECTION_IDENTIFIER = "ConsiderAmpersandAsIntersectionIdentifier";
    public static final String KEY_COORDINATE_ORIGINAL = "ReturnOriginalCoordinates";
    private boolean m_isdefultsMode;

    public NZL_Constraints() {
        this.setDefualtValues();
    }

    public NZL_Constraints(IGeocodeConstraints defaults) {
        super(defaults);
    }

    public boolean getDataConstructionConstraint() {
        return this.isDataConstructionConstraint;
    }

    public void setDataConstructionConstraint(boolean dataConstruction) {
        this.isDataConstructionConstraint = dataConstruction;
    }

    public static NZL_Constraints convertFromConstraints(IConstraints inConstraints, IHandler handler) {
        NZL_Constraints newConstraints = new NZL_Constraints((IGeocodeConstraints)inConstraints);
        if (handler != null) {
            newConstraints.setHandler(handler);
        }
        return newConstraints;
    }

    public void setStandardMode(boolean stdMode) {
        this.m_isdefultsMode = stdMode;
    }

    public boolean isStandardMatchMode() {
        return this.m_isdefultsMode;
    }

    protected void setDefaultSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(false);
        constraints.setMustMatchArea2(false);
        constraints.setMustMatchArea3(false);
        constraints.setMustMatchArea4(false);
        constraints.setMustMatchAddressNumber(false);
        constraints.setMustMatchMainAddress(false);
        constraints.setMustMatchPostalCode(false);
        constraints.setMustMatchInput(false);
        constraints.setMustMatchCountry(true);
        this.setStandardMode(true);
    }

    private void setDefualtValues() {
        this.setGeocodeType(0);
        this.setClientCoordinateSystem("epsg:4326");
        this.setClientLocale(Locale.getDefault());
        this.setReturnCloseCandidatesOnly(false);
        this.setMustMatchPostalCode(false);
        this.setMustMatchAddressNumber(false);
        this.setReturnCloseCandidatesOnly(false);
        this.setMustMatchArea3(false);
        this.setMustMatchArea4(false);
        this.setMustMatchInput(false);
        this.setMustMatchMainAddress(false);
        this.setFallbackToGeographic(false);
        this.setFallbackToPostal(false);
        this.setMustMatchCountry(true);
        this.setMaxCandidates(3);
        this.setMaxRanges(-1);
        this.setCornerOffset(7.0);
        this.setStreetOffset(7.0);
        this.setCornerOffsetUnits("m");
        this.setStreetOffsetUnits("m");
        this.setCustomString(RELAXED_MODE, "true");
        this.setCustomString(KEY_CONSIDER_AMPERSAND_AS_INTERSECTION_IDENTIFIER, "false");
        this.setCustomString(KEY_COORDINATE_ORIGINAL, "false");
    }

    public String setCustomString(String key, String value) {
        return this.m_constraints.setCustomString(key, value);
    }
}

