/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.EMEA.EMEA_GeocodeConstraints;

public class NZL_GeocodeConstraints
extends EMEA_GeocodeConstraints {
    public static final String KEY_MUST_MATCH_POSTCODE = "MustMatchPostcode";
    public static final String KEY_MUST_MATCH_HNR = "MustMatchHouseNumber";
    public static final String KEY_MUST_MATCH_STR = "MustMatchStreet";
    public static final String KEY_MUST_MATCH_TOWN = "MustMatchTown";
    public static final String KEY_MUST_MATCH_PROVINCE = "MustMatchProvince";
    public static final String KEY_MUST_MATCH_REGION = "MustMatchRegion";
    public static final String KEY_MUST_MATCH_SUBURB = "MustMatchSuburb";
    public static final String KEY_CONSIDER_AMPERSAND_AS_INTERSECTION_IDENTIFIER = "ConsiderAmpersandAsIntersectionIdentifier";
    public static final String KEY_COORDINATE_ORIGINAL = "ReturnOriginalCoordinates";

    public void setMustMatchPostcode(boolean bMatch) {
        super.setMustMatchPostalCode(bMatch);
    }

    public boolean isMustMatchPostcode() {
        return super.isMustMatchPostalCode();
    }

    public void setMustMatchHNR(boolean bMatch) {
        super.setMustMatchAddressNumber(bMatch);
    }

    public boolean isMustMatchHNR() {
        return super.isMustMatchAddressNumber();
    }

    public void setMustMatchStreet(boolean bMatch) {
        super.setMustMatchMainAddress(bMatch);
    }

    public boolean isMustMatchStreet() {
        return super.isMustMatchMainAddress();
    }

    public void setMustMatchTown(boolean bMatch) {
        super.setMustMatchArea3(bMatch);
    }

    public boolean isMustMatchTown() {
        return super.isMustMatchArea3();
    }

    public void setMustMatchProvince(boolean bMatch) {
        super.setMustMatchArea2(bMatch);
    }

    public boolean isMustMatchProvince() {
        return super.isMustMatchArea2();
    }

    public void setMustMatchRegion(boolean bMatch) {
        super.setMustMatchArea1(bMatch);
    }

    public boolean isMustMatchRegion() {
        return super.isMustMatchArea1();
    }

    public void setMustMatchSuburb(boolean bMatch) {
        super.setMustMatchArea4(bMatch);
    }

    public boolean isMustMatchSuburb() {
        return super.isMustMatchArea4();
    }

    public void setAmpersandAsIntersectionIdentifier(boolean bUseSingleAmpersand) {
        this.setCustomString(KEY_CONSIDER_AMPERSAND_AS_INTERSECTION_IDENTIFIER, String.valueOf(bUseSingleAmpersand));
    }

    public void setReturnOriginalCoordinates(boolean bUseOriginalCoordinates) {
        this.setCustomString(KEY_COORDINATE_ORIGINAL, String.valueOf(bUseOriginalCoordinates));
    }

    public void setStandardMatchMode() {
        this.setCustomString("MatchMode", "DefaultMode");
    }

    public boolean isStandardMatchMode() {
        return "DefaultMode".equals(this.getCustomString("MatchMode"));
    }

    public void setRelaxedMatchMode() {
        this.setCustomString("MatchMode", "RelaxedMode");
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setMaxRanges(-1);
        this.setAmpersandAsIntersectionIdentifier(false);
        this.setRelaxedMatchMode();
    }

    public String setCustomString(String key, String value) {
        if (KEY_MUST_MATCH_POSTCODE.equals(key)) {
            return super.setCustomString("MustMatchPostalCode", value);
        }
        if (KEY_MUST_MATCH_HNR.equals(key)) {
            return super.setCustomString("MustMatchAddrNum", value);
        }
        if (KEY_MUST_MATCH_STR.equals(key)) {
            return super.setCustomString("MustMatchMainAddr", value);
        }
        if (KEY_MUST_MATCH_TOWN.equals(key)) {
            return super.setCustomString("MustMatchArea3", value);
        }
        if (KEY_MUST_MATCH_PROVINCE.equals(key)) {
            return super.setCustomString("MustMatchArea2", value);
        }
        if (KEY_MUST_MATCH_REGION.equals(key)) {
            return super.setCustomString("MustMatchArea1", value);
        }
        if (KEY_MUST_MATCH_SUBURB.equals(key)) {
            return super.setCustomString("MustMatchArea4", value);
        }
        return super.setCustomString(key, value);
    }

    public String getCustomString(String key) {
        if (KEY_MUST_MATCH_POSTCODE.equals(key)) {
            return super.getCustomString("MustMatchPostalCode");
        }
        if (KEY_MUST_MATCH_HNR.equals(key)) {
            return super.getCustomString("MustMatchAddrNum");
        }
        if (KEY_MUST_MATCH_STR.equals(key)) {
            return super.getCustomString("MustMatchMainAddr");
        }
        if (KEY_MUST_MATCH_TOWN.equals(key)) {
            return super.getCustomString("MustMatchArea3");
        }
        if (KEY_MUST_MATCH_PROVINCE.equals(key)) {
            return super.getCustomString("MustMatchArea2");
        }
        if (KEY_MUST_MATCH_REGION.equals(key)) {
            return super.getCustomString("MustMatchArea1");
        }
        if (KEY_MUST_MATCH_SUBURB.equals(key)) {
            return super.getCustomString("MustMatchArea4");
        }
        return super.getCustomString(key);
    }
}

