/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.EMEA.EMEA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.NZL.parser.NZL_AddressTerm;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParseMainAddressRule;
import com.mapinfo.mapmarker.NZL.parser.NZL_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class NZL_StreetSingleAddressGeocoder
extends EMEA_StreetSingleAddressGeocoder {
    private int m_currentCase = 0;
    private boolean resetParsedAddress;
    private Address savedParsedAddress;
    private boolean m_resetSearchParsedAddress;
    private Address m_savedSearchParsedAddress;

    public NZL_StreetSingleAddressGeocoder(IHandler handler) {
        super(handler);
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        boolean tryAgain = false;
        if (!this.resetParsedAddress) {
            this.savedParsedAddress = this.copyNZLParsedAddress(constraints.getHandler().getParsedAddress());
        } else {
            this.setParsedAddress(this.copyNZLParsedAddress(this.savedParsedAddress));
            this.resetParsedAddress = false;
        }
        if (!this.m_resetSearchParsedAddress) {
            this.m_savedSearchParsedAddress = this.copyNZLParsedAddress(((ICoreStreetGeocoder)constraints.getHandler()).getSearchParsedAddress());
        } else {
            ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.m_savedSearchParsedAddress);
            this.m_resetSearchParsedAddress = false;
        }
        Address pa = constraints.getHandler().getParsedAddress();
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                constraints.setCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL", "false");
                constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
                this.resetParsedAddress = true;
                tryAgain = true;
                break;
            }
            case 1: {
                ++this.m_currentCase;
                constraints.setCustomString("KEY_GEOBASE_STRING_ONLY", "false");
                this.resetParsedAddress = true;
                tryAgain = true;
                break;
            }
            case 2: {
                ++this.m_currentCase;
                StringBuffer buffer = new StringBuffer();
                String mainAddr = pa.getMainAddress();
                if (mainAddr != null) {
                    if (mainAddr.endsWith("S") || mainAddr.endsWith("s")) {
                        buffer.append(mainAddr.length() > 1 ? mainAddr.substring(0, mainAddr.length() - 1) : mainAddr);
                    } else {
                        buffer.append(mainAddr);
                        buffer.append("S");
                    }
                    pa.setMainAddress(buffer.toString());
                    this.resetParsedAddress = true;
                    ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.copyNZLParsedAddress(pa));
                    this.m_resetSearchParsedAddress = true;
                    return true;
                }
            }
            case 3: {
                String temp;
                int i;
                LinkedList tokensList;
                ++this.m_currentCase;
                boolean madeChange = false;
                StringBuffer buffer = new StringBuffer();
                String mainAddr = pa.getMainAddress();
                if (mainAddr != null && mainAddr.length() > 0) {
                    tokensList = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(mainAddr));
                    for (i = 0; i < tokensList.size(); ++i) {
                        temp = (String)tokensList.get(i);
                        if (NZL_ThoroughfareTypes.isStreetType(temp)) {
                            NZL_ThoroughfareTypes.NZL_ThoroughfareType keyInfo = NZL_ThoroughfareTypes.getThoroughfareType(temp);
                            if (temp.equalsIgnoreCase(keyInfo.getProperTypeName())) {
                                tokensList.set(i, keyInfo.getExpandedTypeName());
                                madeChange = true;
                            } else if (temp.equalsIgnoreCase(keyInfo.getExpandedTypeName())) {
                                tokensList.set(i, keyInfo.getProperTypeName());
                                madeChange = true;
                            }
                        }
                        buffer.append(tokensList.get(i) + " ");
                    }
                    if (madeChange) {
                        pa.setMainAddress(buffer.toString().trim());
                        this.resetParsedAddress = true;
                        ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.copyNZLParsedAddress(pa));
                        this.m_resetSearchParsedAddress = true;
                        return true;
                    }
                }
            }
            case 4: {
                String temp;
                int i;
                LinkedList tokensList;
                ++this.m_currentCase;
                boolean madeChange = false;
                StringBuffer buffer = new StringBuffer();
                String mainAddr = pa.getMainAddress();
                if (mainAddr != null && mainAddr.length() > 0) {
                    tokensList = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(mainAddr));
                    for (i = 0; i < tokensList.size(); ++i) {
                        temp = (String)tokensList.get(i);
                        if (NZL_Abbreviations.isAbbreviation(temp)) {
                            tokensList.set(i, NZL_Abbreviations.getWordForAbbreviation(temp));
                            madeChange = true;
                        } else if (NZL_Abbreviations.isExtended(temp)) {
                            tokensList.set(i, NZL_Abbreviations.getAbbreviationForWord(temp));
                            madeChange = true;
                        }
                        buffer.append(tokensList.get(i) + " ");
                    }
                    if (madeChange) {
                        pa.setMainAddress(buffer.toString().trim());
                        this.resetParsedAddress = true;
                        ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.copyNZLParsedAddress(pa));
                        this.m_resetSearchParsedAddress = true;
                        return true;
                    }
                }
            }
            case 5: {
                ++this.m_currentCase;
                String mainAddr = pa.getMainAddress();
                try {
                    Integer.parseInt(mainAddr);
                    if (pa.getPreThoroughfareType() != null) {
                        pa.setMainAddress(pa.getPreThoroughfareType() + mainAddr);
                        pa.setPreThoroughfareType(null);
                    }
                    this.resetParsedAddress = true;
                    ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.copyNZLParsedAddress(pa));
                    this.m_resetSearchParsedAddress = true;
                    return true;
                }
                catch (NumberFormatException buffer) {
                    // empty catch block
                }
            }
            case 6: {
                ++this.m_currentCase;
                String addNum = pa.getAddressNumber();
                String mainAddr = pa.getMainAddress();
                if (addNum != null && !addNum.equals("")) {
                    pa.setMainAddress(pa.getAddressNumber() + (mainAddr != null ? " " + mainAddr : ""));
                    pa.setAddressNumber((String)null);
                    this.resetParsedAddress = true;
                    ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.copyNZLParsedAddress(pa));
                    this.m_resetSearchParsedAddress = true;
                    return true;
                }
            }
            case 7: {
                ++this.m_currentCase;
                Address inputAddress = constraints.getHandler().getInputAddress();
                String input_mainAddress = NZL_AddressTerm.removeDeliveryPoint(inputAddress.getMainAddress());
                if (input_mainAddress != null) {
                    StringBuffer bufferInputMainaddress = new StringBuffer(input_mainAddress);
                    NZL_ParseMainAddressRule.removePOBox(bufferInputMainaddress);
                    input_mainAddress = bufferInputMainaddress.toString();
                    int firstIndex = input_mainAddress.indexOf("(");
                    int secondIndex = input_mainAddress.indexOf(")");
                    String streetAddressToProcess = null;
                    if (firstIndex > -1 && secondIndex > -1) {
                        String result1 = input_mainAddress.substring(firstIndex, secondIndex + 1);
                        String result = input_mainAddress.replace(result1, "").toLowerCase();
                        StringTokenizer tokenizer = new StringTokenizer(result, "  ");
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (NZL_ThoroughfareTypes.isStreetType(result)) {
                                streetAddressToProcess = result.replaceAll(token, "").trim();
                                continue;
                            }
                            streetAddressToProcess = result;
                        }
                        pa.setMainAddress(streetAddressToProcess);
                    }
                }
                if (pa.getMainAddress() == null) break;
                StringBuffer newAddress = NZL_ParseMainAddressRule.cleanAddress(new StringBuffer(pa.getMainAddress()));
                StringTokenizer tokenList = new StringTokenizer(newAddress.toString(), " ");
                StringBuffer sb = new StringBuffer();
                while (tokenList.hasMoreTokens()) {
                    String token = tokenList.nextToken();
                    if (NZL_AddressTerm.isNumeric(token) || !NZL_AddressTerm.isAlpha(token)) continue;
                    sb.append(token + " ");
                }
                if (sb.toString() != null) {
                    StringTokenizer tokenizer = new StringTokenizer(sb.toString(), "  ");
                    String remainingstreetAddress = null;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (NZL_ThoroughfareTypes.isStreetType(token)) {
                            remainingstreetAddress = sb.toString().replaceAll(token, "").trim();
                            continue;
                        }
                        remainingstreetAddress = sb.toString();
                    }
                    pa.setMainAddress(remainingstreetAddress);
                }
                this.resetParsedAddress = true;
                ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(this.copyNZLParsedAddress(pa));
                this.m_resetSearchParsedAddress = true;
                return true;
            }
        }
        return tryAgain;
    }

    protected String replace(String original, char chFrom, String strTo) {
        if (original == null || original.trim().length() == 0) {
            return null;
        }
        if (strTo == null || strTo.trim().length() == 0) {
            return null;
        }
        int loc = (original = original.toUpperCase()).indexOf(chFrom);
        if (loc == -1) {
            return original;
        }
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < original.length(); ++i) {
            if (original.charAt(i) != chFrom) {
                newString.append(original.charAt(i));
                continue;
            }
            newString.append(strTo);
        }
        return newString == null ? null : newString.toString();
    }

    protected Address copyNZLParsedAddress(Address inputAddress) {
        if (inputAddress == null) {
            return null;
        }
        AddressImpl result = new AddressImpl();
        result.setGenericField1(inputAddress.getGenericField1());
        result.setGenericField2(inputAddress.getGenericField2());
        result.setGenericField3(inputAddress.getGenericField3());
        result.setGenericField4(inputAddress.getGenericField4());
        result.setPreAddress(inputAddress.getPreAddress());
        result.setAddressNumber(inputAddress.getParsedAddressNumber());
        result.setPlaceName(inputAddress.getPlaceName());
        result.setMainAddress(inputAddress.getMainAddress());
        result.setPreThoroughfareType(inputAddress.getPreThoroughfareType());
        result.setPostThoroughfareType(inputAddress.getPostThoroughfareType());
        result.setPostAddress(inputAddress.getPostAddress());
        result.setPostCode1(inputAddress.getPostCode1());
        result.setPostCode2(inputAddress.getPostCode2());
        result.setCountry(inputAddress.getCountry());
        result.setAreaName1(inputAddress.getAreaName1());
        result.setAreaName2(inputAddress.getAreaName2());
        result.setAreaName3(inputAddress.getAreaName3());
        result.setAreaName4(inputAddress.getAreaName4());
        result.setUnitType(inputAddress.getUnitType());
        result.setUnitValue(inputAddress.getUnitValue());
        result.setPreDirectional(inputAddress.getPreDirectional());
        result.setPostDirectional(inputAddress.getPostDirectional());
        if (inputAddress.hasAdditionalFields()) {
            result.setAdditionalFields(new HashMap(inputAddress.getAdditionalFields()));
        }
        return result;
    }
}

