/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.browse;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZL_AddressUtils;
import com.mapinfo.mapmarker.NZL.NZL_InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NZL_BrowseFilter
implements IBrowseFilter {
    public List filterAddresses(IConstraints constraints, Address pa, List candidates) throws MatcherException {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        this.removeDuplicateAddresses(candidates);
        return this.filterCandidates(constraints, pa, candidates);
    }

    private void removeDuplicateAddresses(List candidates) {
        HashSet<NZL_InternalBrowseAddress.StreetBasedIdentifier> set = new HashSet<NZL_InternalBrowseAddress.StreetBasedIdentifier>(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            NZL_InternalBrowseAddress nldBrowseAddress = (NZL_InternalBrowseAddress)((Object)iter.next());
            NZL_InternalBrowseAddress.StreetBasedIdentifier identifier = nldBrowseAddress.getStreetBasedIdentifier();
            if (set.contains(identifier)) {
                iter.remove();
                continue;
            }
            set.add(identifier);
        }
    }

    private List filterCandidates(IConstraints constraints, Address pa, List candidates) {
        FieldScores thresholds = constraints.getHandler().getMatcherConstants().getFieldScores();
        StringScorer scorer = ((CoreHandler)constraints.getHandler()).getScoringHelper().makeStringScorer();
        ArrayList<NZL_InternalBrowseAddress> filteredCandidates = new ArrayList<NZL_InternalBrowseAddress>(candidates.size());
        for (NZL_InternalBrowseAddress address : candidates) {
            NZL_InternalBrowseAddress filteredAddress = this.filterAddress(address, pa, thresholds, constraints, scorer);
            if (filteredAddress == null) continue;
            filteredCandidates.add(filteredAddress);
        }
        return filteredCandidates;
    }

    private NZL_InternalBrowseAddress filterAddress(InternalBrowseAddress address, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        NZL_InternalBrowseAddress filteredAddress = (NZL_InternalBrowseAddress)constraints.getHandler().getBrowseHelper().makeBrowseAddress((Address)address);
        int segmentCount = address.getSegmentCount();
        for (int index = 0; index < segmentCount; ++index) {
            int dictNum;
            Segment segment = address.getSegmentAt(index);
            Segment filteredSegment = this.filterSegment(segment, dictNum = filteredAddress.getDictionaryNumber(), inputAddress, thresholds, constraints, scorer);
            if (filteredSegment == null) continue;
            filteredAddress.addSegment(filteredSegment);
        }
        if (filteredAddress.getSegmentCount() > 0) {
            return filteredAddress;
        }
        return null;
    }

    private Segment filterSegment(Segment segment, int dictNum, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        double postcode1Score;
        IMatchPreferences constants = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, inputAddress);
        EMEA_GeoInfoRecord geoinfo = (EMEA_GeoInfoRecord)segment.getGeoInfoRecord();
        double an3Score = 0.0;
        double an4Score = 0.0;
        String an3 = inputAddress.getAreaName3();
        String an4 = inputAddress.getAreaName4();
        if (NZL_AddressUtils.isEmpty(an3) && NZL_AddressUtils.isEmpty(an4)) {
            an3Score = 1.0;
            an4Score = 1.0;
        } else if (geoinfo != null) {
            an3Score = scorer.scoreString(an3, geoinfo.getAreaName3());
            an4Score = scorer.scoreString(an4, geoinfo.getAreaName4());
            if (NZL_AddressUtils.isEmpty(an4)) {
                if (an3Score == 1.0) {
                    an4Score = 1.0;
                }
            } else if (NZL_AddressUtils.isEmpty(an3) && an4Score == 1.0) {
                an3Score = 1.0;
            }
            if (an3Score != 1.0 || an4Score != 1.0) {
                double tempAn3Score = scorer.scoreString(an3, geoinfo.getAreaName4());
                double tempAn4Score = scorer.scoreString(an4, geoinfo.getAreaName3());
                if (tempAn3Score > an3Score) {
                    an3Score = tempAn3Score;
                }
                if (tempAn4Score > an4Score) {
                    an4Score = tempAn4Score;
                }
            }
        }
        if (constants.getExactMatchAreaName3() ? an3Score != 1.0 : !NZL_AddressUtils.isEmpty(an3) && an3Score < thresholds.getAreaName3()) {
            return null;
        }
        if (constants.getExactMatchAreaName4() ? an4Score != 1.0 : !NZL_AddressUtils.isEmpty(an4) && an4Score < thresholds.getAreaName4()) {
            return null;
        }
        String postcode1 = inputAddress.getPostCode1();
        if (NZL_AddressUtils.isEmpty(postcode1)) {
            postcode1Score = 1.0;
        } else {
            double score = scorer.scoreString(postcode1, segment.getLeftPostCode1());
            postcode1Score = score;
            if (postcode1Score != 1.0) {
                score = scorer.scoreString(postcode1, segment.getRightPostCode1());
                double d = postcode1Score = postcode1Score < score ? score : postcode1Score;
            }
        }
        if (constants.getExactMatchPostalCode1() ? postcode1Score != 1.0 : postcode1Score < thresholds.getPostalCode1()) {
            return null;
        }
        return segment;
    }
}

