/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class NZL_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    protected NZL_GeoInfoFetcherImpl m_infoFetcher = null;

    public NZL_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties, soundex);
        String geoInfoLoc = dataProperties.getProperty("geo2sac_geoinfoLoc");
        try {
            this.m_infoFetcher = new NZL_GeoInfoFetcherImpl(geoInfoLoc, null, null);
        }
        catch (DataDictionaryIntializationException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        if (input.hasAreaName4() && this.stringExists(input.getAreaName4())) {
            String suburb = input.getAreaName4();
            String shortSuburb = NZL_ParsePostAddressRule.removeCommonWords(suburb);
            ArrayList<EMEA_GeoBase> baseHolder = new ArrayList<EMEA_GeoBase>(6);
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(suburb)));
            baseHolder.add(new EMEA_GeoBase(this.getStringKey(suburb)));
            if (shortSuburb != null && !shortSuburb.equalsIgnoreCase(suburb)) {
                baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(shortSuburb)));
                baseHolder.add(new EMEA_GeoBase(this.getStringKey(shortSuburb)));
            }
            ArrayList altLangNames = this.m_infoFetcher.getAltLangNames(suburb);
            int size = altLangNames.size();
            for (int i = 0; i < size; ++i) {
                String altLangName = (String)altLangNames.get(i);
                baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(altLangName)));
                baseHolder.add(new EMEA_GeoBase(this.getStringKey(altLangName)));
            }
            IGeoBase[] bases = baseHolder.toArray(new EMEA_GeoBase[0]);
            return bases;
        }
        return null;
    }

    private MiSoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.toUpperCase();
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        MiSoundexKey mikey = new MiSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    private String getFirstName(String name) {
        String result = null;
        StringTokenizer st = new StringTokenizer(name, " /-");
        if (st.countTokens() != 1) {
            result = st.nextToken();
        }
        return result;
    }
}

