/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.EMEA_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.NZL.NZL_AddressUtils;
import com.mapinfo.mapmarker.NZL.NZL_InternalCandidateAddress;
import com.mapinfo.mapmarker.NZL.NZL_ScoringHelper;
import com.mapinfo.mapmarker.NZL.dp.INZL_RangeDataSourceRecord;
import com.mapinfo.mapmarker.NZL.dp.INZL_UnitDataSourceRecord;
import com.mapinfo.mapmarker.NZL.dp.NZLPostgreSegmentDataSourceRecordImpl;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJRangeRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJSegmentRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.LongPoint;
import java.util.ArrayList;
import java.util.Properties;

public class NZL_PostgreStreetDataSourceRecordConvertorImpl
extends EMEA_StreetDataSourceRecordConvertorImpl {
    public NZL_PostgreStreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyString = alternateBrowseString.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = NZL_ScoringHelper.getFirstNormChar(keyString);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        ArrayList keyBases = this.getKeyBases(address);
        ArrayList<MapMarkerBrowseMultiLevelIndexKey> keys = new ArrayList<MapMarkerBrowseMultiLevelIndexKey>(keyBases.size());
        for (String keyBase : keyBases) {
            int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
            char c = NZL_ScoringHelper.getFirstNormChar(keyBase);
            keys.add(new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey));
        }
        MapMarkerIndexKey[] keyArray = new MapMarkerIndexKey[keys.size()];
        return keys.toArray(keyArray);
    }

    @Override
    protected ArrayList getKeyBases(Address address) {
        ArrayList keyBases = super.getKeyBases(address);
        keyBases.add(NZL_AddressUtils.getFormattedStreetAddress(address, false).toUpperCase());
        return keyBases;
    }

    @Override
    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        NZL_MMJSegmentRecord record = (NZL_MMJSegmentRecord)super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        NZLPostgreSegmentDataSourceRecordImpl sourceSegmentRecord = (NZLPostgreSegmentDataSourceRecordImpl)input;
        if (convertLeft && sourceSegmentRecord.hasLeftMeshBlockId()) {
            record.setLeftMeshBlockId(sourceSegmentRecord.getLeftMeshBlockId());
        }
        if (convertRight && sourceSegmentRecord.hasRightMeshBlockId()) {
            record.setRightMeshBlockId(sourceSegmentRecord.getRightMeshBlockId());
        }
        if (sourceSegmentRecord.hasUniqueID()) {
            record.setUniqueId(sourceSegmentRecord.getUniqueID());
        }
        return record;
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new NZL_MMJSegmentRecord();
    }

    @Override
    protected String makeMainAddressString(String street, String houseNumber) {
        return houseNumber + " " + street;
    }

    @Override
    public boolean canReassembleAddress(String original_street, Address parsed) {
        String parsed_street = NZL_InternalCandidateAddress.reconstructAddress(new NZL_InternalCandidateAddress(parsed));
        boolean result = parsed_street.equals(original_street);
        return result;
    }

    @Override
    public int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        String oddeven = null;
        if (input.hasStatus()) {
            oddeven = input.getStatus();
            switch (oddeven.toUpperCase().charAt(0)) {
                case 'O': {
                    return 1;
                }
                case 'E': {
                    return 2;
                }
                case 'B': {
                    return 0;
                }
            }
            try {
                return super.getOddEven(input);
            }
            catch (DataSourceException e) {
                DataCreationLogger.getLogger().logError("Unable to find data source field");
                throw e;
            }
        }
        return 0;
    }

    private LongPoint makeLongPoint(String longitude, String latitude) {
        String fixedLongitude = this.fixCoordinate(longitude);
        String fixedLatitude = this.fixCoordinate(latitude);
        try {
            long longitudeValue = Long.parseLong(fixedLongitude);
            long latitudeValue = Long.parseLong(fixedLatitude);
            return new LongPoint(longitudeValue, latitudeValue);
        }
        catch (NumberFormatException NFEx) {
            DataCreationLogger.getLogger().logInternalError(NFEx.getMessage());
            return null;
        }
    }

    private String fixCoordinate(String coordinate) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = coordinate.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ' || chars[i] == '.') continue;
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }

    protected MMJRangeUnitRecord makeRangeUnitRecordType() {
        return new NZL_MMJRangeUnitRecord();
    }

    protected MMJRangeUnitRecord convertRangeUnitRecord(IUnitDataSourceRecord input, int sac) throws DataSourceException {
        NZL_MMJRangeUnitRecord record = (NZL_MMJRangeUnitRecord)super.convertRangeUnitRecord(input, sac);
        INZL_UnitDataSourceRecord sourceRangeUnitRecord = (INZL_UnitDataSourceRecord)input;
        if (sourceRangeUnitRecord.hasUniqueID() && record != null) {
            record.setUniqueId(sourceRangeUnitRecord.getUniqueID());
        }
        return record;
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new NZL_MMJRangeRecord();
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        NZL_MMJRangeRecord record = (NZL_MMJRangeRecord)super.convertRangeRecord(input, sac);
        if (record != null) {
            INZL_RangeDataSourceRecord sourceSegmentRecord = (INZL_RangeDataSourceRecord)input;
            if (sourceSegmentRecord.hasLeftMeshBlockId()) {
                record.setLeftMeshBlockId(sourceSegmentRecord.getLeftMeshBlockId());
            }
            if (sourceSegmentRecord.hasRightMeshBlockId()) {
                record.setRightMeshBlockId(sourceSegmentRecord.getRightMeshBlockId());
            }
            if (sourceSegmentRecord.hasOriginalLatitude() && sourceSegmentRecord.hasOriginalLongitude()) {
                record.setOriginalPoint(this.makeLongPoint(sourceSegmentRecord.getOriginalLongitude(), sourceSegmentRecord.getOriginalLatitude()));
            }
        }
        return record;
    }
}

