/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataDictionary;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_Geo2SacRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZLEnglishSoundex;
import com.mapinfo.mapmarker.NZL.NZL_AddressUtils;
import com.mapinfo.mapmarker.NZL.NZL_ScoringHelper;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_AddressFetcher;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class NZL_DataDictionary
extends EMEA_DataDictionary {
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_GEOBASE_USE_PROVINCE_SEARCH = "KEY_GEOBASE_USE_PROVINCE_SEARCH";
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    private static final Soundex m_soundex = NZLEnglishSoundex.getInstance();
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("en", "NZ"), NZL_ScoringHelper.getCollationRules());

    public NZL_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    @Override
    public IGeoBase[] getGeoBases(Address pa, IConstraints preferences) {
        String areaName4 = pa.getAreaName4();
        String areaName3 = pa.getAreaName3();
        String shortAN4 = NZL_ParsePostAddressRule.removeCommonWords(areaName4);
        String shortAN3 = NZL_ParsePostAddressRule.removeCommonWords(areaName3);
        if (!(areaName4 != null && areaName4.trim().length() != 0 || areaName3 != null && areaName3.trim().length() != 0)) {
            return null;
        }
        Vector<Object> bases = new Vector<Object>();
        boolean isGeographicCentroid = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID));
        if (isGeographicCentroid) {
            MiSoundexKey key = null;
            key = (MiSoundexKey)m_soundex.getSoundex(areaName4);
            if (key != null) {
                bases.add(new MiSoundexGeoBase(key));
            }
            if ((key = (MiSoundexKey)m_soundex.getSoundex(shortAN4)) != null) {
                bases.add(new MiSoundexGeoBase(key));
            }
            if ((key = (MiSoundexKey)m_soundex.getSoundex(areaName3)) != null) {
                bases.add(new MiSoundexGeoBase(key));
            }
            if ((key = (MiSoundexKey)m_soundex.getSoundex(shortAN3)) != null) {
                bases.add(new MiSoundexGeoBase(key));
            }
            if (bases.size() > 0) {
                IGeoBase[] retbases = new IGeoBase[bases.size()];
                for (int i = 0; i < bases.size(); ++i) {
                    retbases[i] = (MiSoundexGeoBase)bases.get(i);
                }
                return retbases;
            }
            return null;
        }
        boolean bStringKey = Boolean.valueOf(preferences.getCustomString("KEY_GEOBASE_STRING_ONLY"));
        ISoundexKey soundexKey = null;
        if (areaName4 != null) {
            if (bStringKey) {
                soundexKey = NZLEnglishSoundex.getStringKey(areaName4);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            } else {
                soundexKey = (MiSoundexKey)m_soundex.getSoundex(areaName4);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            }
        }
        if (shortAN4 != null && !shortAN4.equalsIgnoreCase(areaName4)) {
            if (bStringKey) {
                soundexKey = NZLEnglishSoundex.getStringKey(shortAN4);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            } else {
                soundexKey = (MiSoundexKey)m_soundex.getSoundex(shortAN4);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            }
        }
        if (areaName3 != null) {
            if (bStringKey) {
                soundexKey = NZLEnglishSoundex.getStringKey(areaName3);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            } else {
                soundexKey = (MiSoundexKey)m_soundex.getSoundex(areaName3);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            }
        }
        if (shortAN3 != null && !shortAN3.equalsIgnoreCase(areaName3)) {
            if (bStringKey) {
                soundexKey = NZLEnglishSoundex.getStringKey(shortAN3);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            } else {
                soundexKey = (MiSoundexKey)m_soundex.getSoundex(shortAN3);
                if (soundexKey != null) {
                    bases.add(new EMEA_GeoBase((MiSoundexKey)soundexKey));
                }
            }
        }
        if (bases.size() > 0) {
            IGeoBase[] retbases = new IGeoBase[bases.size()];
            for (int i = 0; i < bases.size(); ++i) {
                retbases[i] = (EMEA_GeoBase)bases.get(i);
            }
            return retbases;
        }
        return null;
    }

    @Override
    protected IPostalBase makePostalBase(String zipCode) {
        if (zipCode == null || zipCode.length() != 4) {
            return null;
        }
        return new StandardPostalBase(zipCode);
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new EMEA_Geo2SacRecord();
    }

    protected IAddressFetcher initAddressFetcher() {
        return new NZL_AddressFetcher(this.getDataManagerSettings(), null);
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int i) {
        String areaName4 = pa.getAreaName4();
        if (areaName4 == null || areaName4.length() == 0) {
            return null;
        }
        MiSoundexKey key = (MiSoundexKey)m_soundex.getSoundex(areaName4);
        if (key == null) {
            return null;
        }
        List alternatesList = new ArrayList<MiSoundexKey>();
        alternatesList.add(key);
        switch (i) {
            case 0: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName4, (ISoundexKey)key, 32, alternatesList);
                break;
            }
            case 1: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName4, (ISoundexKey)key, 1, alternatesList);
                break;
            }
            case 2: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName4, (ISoundexKey)key, 16, alternatesList);
                break;
            }
            case 3: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName4, (ISoundexKey)key, 8, alternatesList);
                break;
            }
            case 4: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName4, (ISoundexKey)key, 2, alternatesList);
                break;
            }
            case 5: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName4, (ISoundexKey)key, 4, alternatesList);
                break;
            }
            default: {
                return null;
            }
        }
        if (alternatesList == null) {
            return null;
        }
        int size = alternatesList.size();
        Object[] objs = alternatesList.toArray();
        IGeoBase[] retvals = new EMEA_GeoBase[size];
        for (int j = 0; j < size; ++j) {
            retvals[j] = new EMEA_GeoBase((MiSoundexKey)new MiSoundexGeoBase((MiSoundexKey)objs[j]));
        }
        return retvals;
    }

    @Override
    protected CollationKeyGenerator getCollationKeyGenerator() {
        return m_collationKeyGenerator;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new NZL_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        NZL_PostInfoFetcherImpl postfetcher = null;
        if (!this.isUserDictionary()) {
            postfetcher = new NZL_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return postfetcher;
    }

    @Override
    protected Soundex getSoundex() {
        return m_soundex;
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String mainAddrItem = addr.getMainAddress();
        if (NZL_AddressUtils.isEmpty(mainAddrItem)) {
            String placeName = addr.getPlaceName();
            String browseStrKey = null;
            if (placeName != null) {
                browseStrKey = placeName.trim();
            }
            if (NZL_AddressUtils.isEmpty(browseStrKey)) {
                return null;
            }
            return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
        }
        String browseStrKeyFull = NZL_AddressUtils.getFormattedStreetAddress(addr, false);
        MapMarkerBrowseMultiLevelIndexKey[] keys = new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(mainAddrItem), this.createBrowseIndexKey(browseStrKeyFull)};
        return keys;
    }

    private MapMarkerBrowseMultiLevelIndexKey createBrowseIndexKey(String browseStrKey) {
        char c = NZL_ScoringHelper.getFirstNormChar(browseStrKey);
        int[] collationKey1 = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        return new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey1);
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        ISoundexKey[] retvals = null;
        String origStr = addr.getMainAddress();
        ISoundexKey origKey = this.getSoundex().getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        retvals = new ISoundexKey[]{origKey};
        return retvals;
    }
}

