/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary;

import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import java.util.Iterator;

public class NZL_MultiSegmentStreet
extends MultiSegmentStreet {
    private MMJSegmentComparer m_segmentComparer;

    public NZL_MultiSegmentStreet(MMJStreetRecord streetRecord, MMJSegmentComparer segmentComparer) {
        super(streetRecord, segmentComparer);
        this.m_segmentComparer = segmentComparer;
    }

    public void addSegment(MMJSegmentRecord segment) {
        NZL_MMJSegmentRecord previousSegment = this.getCombinableSegment((NZL_MMJSegmentRecord)segment);
        if (previousSegment == null) {
            this.getSegments().add(segment);
        } else {
            this.combine((NZL_MMJSegmentRecord)segment, previousSegment);
        }
    }

    private NZL_MMJSegmentRecord getCombinableSegment(NZL_MMJSegmentRecord segment) {
        for (NZL_MMJSegmentRecord previousSegment : this.getSegments()) {
            if (!this.m_segmentComparer.segmentsCompare((MMJSegmentRecord)segment, (MMJSegmentRecord)previousSegment)) continue;
            if (segment.isPointHouseSegment()) {
                return previousSegment;
            }
            if (segment.getRanges() == null || previousSegment.getRanges() == null) continue;
            MMJRangeRecord rangeRecord_Segment = (MMJRangeRecord)segment.getRanges().get(0);
            MMJRangeRecord rangeRecord_PreviousSegment = (MMJRangeRecord)previousSegment.getRanges().get(0);
            if (!rangeRecord_Segment.getFromHouse().equals((Object)rangeRecord_PreviousSegment.getFromHouse()) || !rangeRecord_Segment.getToHouse().equals((Object)rangeRecord_PreviousSegment.getToHouse())) continue;
            return previousSegment;
        }
        return null;
    }

    private void combine(NZL_MMJSegmentRecord segment, NZL_MMJSegmentRecord previousSegment) {
        if (segment.getRanges() != null) {
            Iterator rangeIterator = segment.getRanges().iterator();
            while (rangeIterator.hasNext()) {
                previousSegment.addRange((MMJRangeRecord)rangeIterator.next());
            }
        }
    }
}

