/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.tab;

import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJSegmentRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MultiSegmentStreet;
import com.mapinfo.mapmarker.NZL.dp.tab.NZL_TabStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataHandler;
import java.util.Iterator;

public class NZL_TabStreetDataHandler
extends TabStreetDataHandler {
    public NZL_TabStreetDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, MMJStreetRecordComparator streetComparator, MMJSegmentComparer segmentComparer, ITempDataRecordHandler tempHandler) {
        super(dataSourceAccess, dataConvertor, intermediateHandler, streetComparator, segmentComparer, tempHandler);
    }

    protected IDataSourceRecord makeDataSourceRecord(IDataSourceRecordObjects objects) {
        return new NZL_TabStreetDataSourceRecord((TabDataSourceRecordObjects)objects);
    }

    protected MultiSegmentStreet makeMultiSegmentStreet(MMJStreetRecord street) {
        return new NZL_MultiSegmentStreet(street, this.getSegmentComparer());
    }

    public Object getNextDataRecord() throws DataCreationException {
        NZL_MultiSegmentStreet street = (NZL_MultiSegmentStreet)((Object)super.getNextDataRecord());
        if (street != null) {
            Iterator segmentIterator = street.getSegments().iterator();
            while (segmentIterator.hasNext()) {
                this.fixRangesOnSegment((NZL_MMJSegmentRecord)((Object)segmentIterator.next()));
            }
        }
        return street;
    }

    private void fixRangesOnSegment(NZL_MMJSegmentRecord segment) {
        if (this.containsUnits(segment)) {
            Iterator rangeIterator = segment.getRanges().iterator();
            MMJRangeRecord previousRange = (MMJRangeRecord)rangeIterator.next();
            while (rangeIterator.hasNext()) {
                MMJRangeRecord range = (MMJRangeRecord)rangeIterator.next();
                if (this.representSameRange(previousRange, range)) {
                    if (range.getRangeUnits() == null || range.getRangeUnits().isEmpty()) continue;
                    Iterator unitIterator = range.getRangeUnits().iterator();
                    while (unitIterator.hasNext()) {
                        previousRange.addRangeUnit((MMJRangeUnitRecord)unitIterator.next());
                    }
                    rangeIterator.remove();
                    continue;
                }
                previousRange = range;
            }
        }
    }

    private boolean containsUnits(MMJSegmentRecord segment) {
        if (segment.getRanges() != null) {
            for (MMJRangeRecord range : segment.getRanges()) {
                if (range.getRangeUnits() == null || range.getRangeUnits().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean representSameRange(MMJRangeRecord range1, MMJRangeRecord range2) {
        if (range1.getOddEven() != range2.getOddEven()) {
            return false;
        }
        if (!range1.getFromHouse().equals((Object)range2.getFromHouse())) {
            return false;
        }
        if (!range1.getToHouse().equals((Object)range2.getToHouse())) {
            return false;
        }
        return range1.getPoint().equals((Object)range2.getPoint());
    }
}

