/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.ud.tab;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.NZL.NZLEnglishSoundex;
import com.mapinfo.mapmarker.NZL.NZL_Constraints;
import com.mapinfo.mapmarker.NZL.NZL_ScoringHelper;
import com.mapinfo.mapmarker.NZL.dp.NZL_DataConstructionParser;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_StreetBuilder;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_TabDataProvider;
import com.mapinfo.mapmarker.NZL.dp.binary.index.NZL_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.NZL.dp.intermediate.NZL_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.NZL.dp.tab.NZL_TabStreetDataHandler;
import com.mapinfo.mapmarker.NZL.dp.ud.NZL_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.NZL.dp.ud.tab.NZL_UDGeoInfoDataHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class NZL_TabUDDataProvider
extends AbstractUDDataProvider {
    private static GeoInfoSoundexIndexer m_GeoInfoSoundexIndexer = null;
    private NZL_TabDataProvider m_tabDataProvider = new NZL_TabDataProvider();
    private String m_geoInfoPathAndBaseName;
    private NZL_UDStreetDataSourceRecordConvertor m_nzlStreetRecordConverter = null;
    private static final int DATATYPE_USER_DICTIONARY = 10;

    @Override
    public MMJComplexDataFileMetadata getGeoInfoMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metadata = this.m_tabDataProvider.getGeoInfoMetadata();
        metadata.setDataFileMasks(this.getGeoInfoDataFileMasks());
        metadata.setVendorCode(10);
        return metadata;
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        if (m_GeoInfoSoundexIndexer == null) {
            m_GeoInfoSoundexIndexer = new NZL_GeoInfoSoundexIndexer();
            ((NZL_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.m_geoInfoPathAndBaseName);
        }
        return m_GeoInfoSoundexIndexer;
    }

    @Override
    public MMJComplexDataFileMetadata getPostInfoMetadata() throws DataCreationException {
        return null;
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_dataBuilder = new NZL_StreetBuilder();
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_postInfoDataHandler = null;
        this.m_geoInfoDataHandler = new NZL_UDGeoInfoDataHandler();
        NZL_Constraints constraints = new NZL_Constraints();
        this.m_nzlStreetRecordConverter = new NZL_UDStreetDataSourceRecordConvertor(processingProperties, (UDPost2SacDataHandler)this.m_post2sacDataHandler, (UDGeo2SacDataHandler)this.m_geo2sacDataHandler, NZLEnglishSoundex.getInstance(), new CollationKeyGenerator(new Locale("en", "NZ"), NZL_ScoringHelper.getCollationRules()), new NZL_DataConstructionParser(), constraints, (NZL_UDGeoInfoDataHandler)this.m_geoInfoDataHandler);
        String tempStreetFileFullName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"street.tmp");
        this.m_streetDataHandler = new NZL_TabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)this.m_nzlStreetRecordConverter, (IIntermediateDataHandler)new NZL_IntermediateStreetDataFileFormatHandler(tempStreetFileFullName), new NZL_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String geoUDFilePath = processingProperties.getProperty("geoInfo_outputFilePath");
        this.m_geoInfoPathAndBaseName = geoUDFilePath + File.separator + "geoinfo";
    }

    public void processStreets(boolean createStatistics) throws DataCreationException {
        try {
            super.processStreets(createStatistics);
        }
        finally {
            if (this.m_nzlStreetRecordConverter != null) {
                this.m_nzlStreetRecordConverter.close();
                this.m_nzlStreetRecordConverter = null;
            }
        }
    }

    @Override
    public void preProcessStreetDataSet() throws DataCreationException {
        super.preProcessStreetDataSet();
        ((EMEA_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.m_geoInfoPathAndBaseName);
    }

    @Override
    public void createOtherFiles() throws DataCreationException {
        super.createOtherFiles();
        this.convertGeoInfoIndexFile();
    }

    private void convertGeoInfoIndexFile() throws DataCreationException {
        this.processGeoInfo(false);
        IndexFileConvertor geoInfoStandardConvertor = this.getExactMatchGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tdx", this.m_geoInfoPathAndBaseName + ".jdx");
        if (geoInfoStandardConvertor != null) {
            try {
                DataCreationLogger.getLogger().logStatus("Creating geoInfo exact index file.");
                geoInfoStandardConvertor.convert();
                DataCreationLogger.getLogger().logStatus("Finished creating geoInfo exact index file.");
            }
            catch (DataCreationException e) {
                throw new DataCreationException(400, (Throwable)e);
            }
        }
        this.deleteFile(this.m_geoInfoPathAndBaseName + ".tdx");
        GeoInfoSoundexIndexer indexer = this.getGeoInfoSoundexIndexer();
        if (indexer != null) {
            DataCreationLogger.getLogger().logStatus("Creating temporary geoInfo soundex index file.");
            indexer.processGeoInfoFile(this.m_geoInfoPathAndBaseName);
            DataCreationLogger.getLogger().logStatus("Finished creating temporary geoInfo soundex index file.");
            IndexFileConvertor geoInfoSoundexConvertor = this.getSoundexGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tsx", this.m_geoInfoPathAndBaseName + ".sdx");
            if (geoInfoSoundexConvertor != null) {
                try {
                    DataCreationLogger.getLogger().logStatus("Creating geoInfo soundex index file.");
                    geoInfoSoundexConvertor.convert();
                    this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
                    DataCreationLogger.getLogger().logStatus("Finished creating soundex geoInfo index file.");
                }
                catch (DataCreationException e) {
                    throw new DataCreationException(400, (Throwable)e);
                }
            } else {
                this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
            }
        }
    }

    public DataFileMasks getPostInfoDataFileMasks() {
        return null;
    }

    public DataFileMasks getGeoInfoDataFileMasks() {
        return new DataFileMasks();
    }

    public MMJComplexDataFileMetadata getStreetMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metadata = this.m_tabDataProvider.getStreetMetadata();
        metadata.setVendorCode(10);
        return metadata;
    }
}

