/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class NZL_Abbreviations {
    private static Properties m_wordKeys = null;

    public static void load() throws Throwable {
        try {
            if (m_wordKeys == null) {
                Properties temp = new Properties();
                m_wordKeys = new Properties();
                temp.load(NZL_Abbreviations.class.getResourceAsStream("NZL_Abbreviations.properties"));
                Enumeration<Object> em = temp.keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    NZL_Abbreviations.processLine((String)temp.get(key));
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for NZL_Parser.");
        }
    }

    public static boolean isAbbreviation(String word) {
        if (word == null || word.trim().length() == 0) {
            return false;
        }
        return m_wordKeys.containsKey(word.toUpperCase());
    }

    public static boolean isExtended(String word) {
        if (word == null || word.trim().length() == 0) {
            return false;
        }
        return m_wordKeys.containsValue(word.toUpperCase());
    }

    public static boolean hasAbbreviation(String term) {
        boolean result = false;
        if (term == null || term.trim().length() == 0) {
            return result;
        }
        StringTokenizer tokens = new StringTokenizer(term.toUpperCase());
        while (tokens.hasMoreTokens()) {
            if (!m_wordKeys.containsKey(tokens.nextToken())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getAbbreviationForWord(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        String temp = null;
        String value = null;
        if (m_wordKeys.containsValue(word.toUpperCase())) {
            Enumeration<Object> keys = m_wordKeys.keys();
            while (keys.hasMoreElements()) {
                temp = (String)keys.nextElement();
                value = (String)m_wordKeys.get(temp);
                if (!value.equalsIgnoreCase(word)) continue;
                return temp;
            }
        }
        return temp;
    }

    public static String getWordForAbbreviation(String abbr) {
        if (abbr == null || abbr.trim().length() == 0) {
            return null;
        }
        return (String)m_wordKeys.get(abbr.toUpperCase());
    }

    public static boolean containAbbreviations(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words.toUpperCase(), " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!NZL_Abbreviations.isAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static boolean containWordThatCanBeAbbreviated(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (NZL_Abbreviations.getAbbreviationForWord(temp) == null) continue;
            return true;
        }
        return false;
    }

    private static void processLine(String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        int firstComma = (value = value.toUpperCase()).indexOf(",");
        if (firstComma == -1) {
            return;
        }
        String key = value.substring(0, firstComma);
        if (key == null) {
            return;
        }
        String newValue = value.substring(firstComma + 1, value.length());
        if (newValue == null) {
            return;
        }
        m_wordKeys.put(key.toUpperCase(), newValue.toUpperCase());
    }

    public static ArrayList createAbbreviationAlternatives(String inputTerm) {
        if (inputTerm == null || inputTerm.trim().length() == 0) {
            return null;
        }
        StringTokenizer inputIter = new StringTokenizer(inputTerm, ",- ", false);
        if (inputIter.countTokens() == 1 && (inputTerm.indexOf(".") > -1 || inputTerm.indexOf("/") > -1)) {
            inputIter = new StringTokenizer(inputTerm, ".\\/", false);
        }
        if (inputIter.countTokens() == 0) {
            return null;
        }
        ArrayList<StringBuffer> returnList = new ArrayList<StringBuffer>();
        StringBuffer fullTerm = null;
        StringTokenizer abbrIter = null;
        String expandedTerm = null;
        boolean firstPass = true;
        while (inputIter.hasMoreTokens()) {
            expandedTerm = null;
            String term = inputIter.nextToken();
            if (NZL_Abbreviations.isAbbreviation(term)) {
                expandedTerm = NZL_Abbreviations.getWordForAbbreviation(term);
            }
            if (expandedTerm == null || expandedTerm.trim().length() == 0) {
                if (firstPass) {
                    firstPass = false;
                    returnList = new ArrayList();
                    fullTerm = new StringBuffer(term + " ");
                    returnList.add(fullTerm);
                    continue;
                }
                for (int i = 0; i < returnList.size(); ++i) {
                    StringBuffer temp = (StringBuffer)returnList.get(i);
                    temp.append(term + " ");
                }
                continue;
            }
            if (firstPass) {
                firstPass = false;
            }
            abbrIter = new StringTokenizer(expandedTerm, ",", false);
            int abbrCount = abbrIter.countTokens();
            ArrayList<StringBuffer> tempList = new ArrayList<StringBuffer>((returnList.size() == 0 ? 1 : returnList.size()) * abbrCount);
            while (abbrIter.hasMoreTokens()) {
                String temp = abbrIter.nextToken();
                if (returnList.size() == 0) {
                    fullTerm = new StringBuffer(temp + " ");
                    tempList.add(fullTerm);
                    continue;
                }
                int lastPassListSize = returnList.size();
                for (int i = 0; i < lastPassListSize; ++i) {
                    StringBuffer sb2 = new StringBuffer(((StringBuffer)returnList.get(i)).toString());
                    sb2.append(temp + " ");
                    tempList.add(sb2);
                }
            }
            returnList = tempList;
        }
        return returnList.size() == 0 ? null : returnList;
    }

    public static Set getCommonWords() {
        Set<Object> set = m_wordKeys.keySet();
        set.add(m_wordKeys.values());
        return set;
    }

    public static boolean isCommonTerm(String term) {
        boolean result = false;
        if (term == null) {
            result = false;
        }
        if (m_wordKeys != null && (m_wordKeys.containsKey(term.toUpperCase()) || m_wordKeys.containsValue(term.toUpperCase()))) {
            result = true;
        }
        return result;
    }

    public static String expandAbbreviations(String name) {
        if (name == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(name, "- ", true);
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreTokens()) {
            String abbr;
            String str = st.nextToken();
            if (str.endsWith(".") && !str.equals(".")) {
                str = str.substring(0, str.length() - 1);
            }
            if ((abbr = NZL_Abbreviations.getWordForAbbreviation(str)) != null) {
                buf.append(abbr);
                continue;
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static String abbreviateWords(String words) {
        if (words == null || words.trim().length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(words, " ", true);
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreTokens()) {
            String abbr;
            String str = st.nextToken();
            if (str.endsWith(".")) {
                str = str.substring(0, str.length() - 1);
            }
            if ((abbr = NZL_Abbreviations.getAbbreviationForWord(str)) != null) {
                buf.append(abbr);
                continue;
            }
            buf.append(str);
        }
        return buf.toString();
    }

    static {
        try {
            NZL_Abbreviations.load();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }
}

