/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import com.mapinfo.mapmarker.NZL.NZLEnglishSoundex;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class NZL_CityNames {
    private static Set m_cities = new HashSet();
    private static Set m_citiesSndx = new HashSet();
    private static final String CITIES_PROPERTIES = "NZL_Cities.properties";

    public static boolean isPossibleMultiWordAreaName(String areaname) {
        if (areaname == null || areaname.trim().length() == 0) {
            return false;
        }
        ISoundexKey soundexKey = NZLEnglishSoundex.getInstance().getSoundex(areaname);
        if (soundexKey != null) {
            return m_citiesSndx.contains(soundexKey.toString());
        }
        return false;
    }

    public static boolean isMultiWordAreaName(String areaname) {
        if (areaname == null || areaname.trim().length() == 0) {
            return false;
        }
        return m_cities.contains(areaname.toUpperCase());
    }

    static {
        try {
            InputStream in = NZL_CityNames.class.getResourceAsStream(CITIES_PROPERTIES);
            ISoundexKey soundexKey = null;
            BufferedReader buf = new BufferedReader(new InputStreamReader(in));
            String inputLine = "";
            while (inputLine != null) {
                inputLine = buf.readLine();
                if (inputLine == null) continue;
                inputLine = inputLine.toUpperCase().trim();
                m_cities.add(inputLine);
                soundexKey = NZLEnglishSoundex.getInstance().getSoundex(inputLine);
                m_citiesSndx.add(soundexKey.toString());
            }
        }
        catch (Throwable t) {
            MMJLog.getLog().error("Unable to load required files for NZL cities.");
        }
    }
}

