/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.NZL.NZL_InternalConstants;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.parser.IIntersectionParser;
import java.util.regex.Matcher;

public class NZL_IntersectionParser
implements IIntersectionParser {
    private IGeocodeConstraints m_Constraints;

    public NZL_IntersectionParser(IGeocodeConstraints inconstraints) {
        this.m_Constraints = inconstraints;
    }

    public Address[] getIntersectionAddresses(Address addrIn) {
        boolean isIdentifier = false;
        String isIntersectionIdentifier = this.m_Constraints.getCustomString("ConsiderAmpersandAsIntersectionIdentifier");
        if (isIntersectionIdentifier != null && isIntersectionIdentifier != "") {
            isIdentifier = new Boolean(isIntersectionIdentifier);
        }
        Address[] ura = null;
        String mainLine = NZL_IntersectionParser.removeSpacesAroundAmpersand(addrIn.getMainAddress());
        if (mainLine == null || mainLine.trim().length() == 0) {
            ura = new Address[]{addrIn};
        } else {
            int tokenIndex = mainLine.indexOf("&&");
            int index = -1;
            if (isIdentifier) {
                index = mainLine.indexOf("&");
                int lastIndex = mainLine.lastIndexOf("&");
                if (index != -1) {
                    if (index != lastIndex) {
                        index = lastIndex;
                    } else if (Character.isDigit(mainLine.charAt(index + 1)) || Character.isDigit(mainLine.charAt(index + 2))) {
                        index = -1;
                    }
                }
            }
            if (tokenIndex > -1 || index > -1) {
                ura = new Address[]{new AddressImpl(addrIn), new AddressImpl(addrIn)};
                String strLeft = null;
                String strRight = null;
                if (tokenIndex > -1) {
                    strLeft = mainLine.substring(0, tokenIndex).trim();
                    strRight = mainLine.substring(tokenIndex + 2).trim();
                } else if (index > -1) {
                    strLeft = mainLine.substring(0, index).trim();
                    strRight = mainLine.substring(index + 1).trim();
                }
                ura[0].setMainAddress(strLeft);
                ura[1].setMainAddress(strRight);
            } else {
                ura = new Address[]{addrIn};
            }
        }
        return ura;
    }

    public static String removeSpacesAroundAmpersand(String word) {
        if (word != null) {
            Matcher ampersandMatcher = NZL_InternalConstants.SPACES_AROUND_AMPERSAND_PATTERN.matcher(word);
            String matchedString = null;
            if (ampersandMatcher.find()) {
                matchedString = ampersandMatcher.group();
            }
            if (matchedString != null && !matchedString.equals("")) {
                word = word.replaceAll(matchedString, "&").trim();
            }
        }
        return word;
    }
}

