/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.NZL.parser.NZL_AddressTerm;
import com.mapinfo.mapmarker.NZL.parser.NZL_CityNames;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class NZL_ParsePostAddressRule
implements IParseRule {
    private final short VALID_POSTCODE_LENGTH = (short)4;
    private static char[] delimiters = new char[]{',', ' ', '-', '/', '.', '(', ')', ';', ':', '\t', '\"'};

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String postcode = null;
        String suburb = null;
        String city = null;
        if (ura.getPostCode1() != null) {
            postcode = NZL_AddressTerm.removeDoubleQuotes(ura.getPostCode1());
            if (!this.isPostalCode((postcode = NZL_AddressTerm.removeDeliveryPoint(postcode)).trim())) {
                postcode = null;
                pa.setPostCode1(null);
            } else {
                pa.setPostCode1(this.padWithLeadingZeros(postcode.trim()));
            }
        }
        if (ura.getAreaName4() != null && ura.getAreaName4().trim().length() > 0) {
            suburb = NZL_AddressTerm.removeDoubleQuotes(ura.getAreaName4());
            suburb = NZL_AddressTerm.removeDeliveryPoint(suburb.trim());
            pa.setAreaName4(suburb.trim());
        }
        if (ura.getAreaName3() != null && ura.getAreaName3().trim().length() > 0) {
            city = NZL_AddressTerm.removeDoubleQuotes(ura.getAreaName3());
            city = NZL_AddressTerm.removeDeliveryPoint(city.trim());
            pa.setAreaName3(city.trim());
        }
        if (suburb != null && postcode != null && city != null) {
            return;
        }
        if (ura.getPostAddress() != null && ura.getPostAddress().trim().length() > 0) {
            String postAddr = NZL_AddressTerm.removeDoubleQuotes(ura.getPostAddress());
            postAddr = NZL_AddressTerm.removeDeliveryPoint(postAddr);
            StringBuffer postAddress = new StringBuffer(postAddr);
            postAddress = NZL_ParsePostAddressRule.cleanAddress(postAddress);
            this.seperatePostcode(postAddress, pa);
            this.seperateTownNames(postAddress, pa);
            pa.setPostAddress(null);
        }
    }

    private boolean isPostalCode(String pc) {
        return StringUtilities.isNumeric((String)pc) && pc.length() <= 4;
    }

    public static boolean isValidTownName(String town) {
        return !StringUtilities.hasNumeric((String)town);
    }

    private static boolean isDelimiter(char ch) {
        for (int i = 0; i < delimiters.length; ++i) {
            if (ch != delimiters[i]) continue;
            return true;
        }
        return false;
    }

    private static StringBuffer cleanAddress(StringBuffer str) {
        int i;
        char[] strArray = str.toString().trim().toCharArray();
        for (i = 0; i < strArray.length && NZL_ParsePostAddressRule.isDelimiter(strArray[i]); ++i) {
            strArray[i] = 32;
        }
        for (i = strArray.length - 1; i >= 0 && NZL_ParsePostAddressRule.isDelimiter(strArray[i]); --i) {
            strArray[i] = 32;
        }
        StringTokenizer tokens = new StringTokenizer(new String(strArray).trim(), new String(delimiters));
        str = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            str.append(tokens.nextToken()).append(" ");
        }
        if (str.length() > 0) {
            str.delete(str.length() - 1, str.length());
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void seperatePostcode(StringBuffer postAddress, Address pa) throws ParserException {
        if (pa.getPostCode1() != null) {
            return;
        }
        StringBuffer townx = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(postAddress.toString(), " ,");
        if (tokens.countTokens() == 0) {
            return;
        }
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        if (listOfTokens == null) return;
        if (listOfTokens.size() < 1) {
            return;
        }
        int tokenCount = listOfTokens.size();
        if (tokenCount == 1) {
            String token = (String)listOfTokens.getFirst();
            if (this.isPostalCode(token = token.trim()) && pa.getPostCode1() == null) {
                pa.setPostCode1(this.padWithLeadingZeros(token));
                return;
            }
            if (!StringUtilities.hasNumeric((String)token)) return;
            return;
        } else {
            for (int i = 0; i < listOfTokens.size(); ++i) {
                String token = (String)listOfTokens.get(i);
                if (this.isPostalCode(token = token.trim()) && pa.getPostCode1() == null) {
                    pa.setPostCode1(this.padWithLeadingZeros(token));
                    continue;
                }
                townx.append(token + " ");
            }
            postAddress.delete(0, postAddress.length());
            postAddress.append(townx.toString().trim());
        }
    }

    private void seperateTownNames(StringBuffer postAddress, Address pa) {
        StringTokenizer tokenizer = new StringTokenizer(postAddress.toString(), ", \t\n\r\f/-()+;:");
        int tokenCount = 0;
        tokenCount = tokenizer.countTokens();
        if (tokenCount < 2) {
            tokenizer = new StringTokenizer(postAddress.toString());
            tokenCount = tokenizer.countTokens();
        }
        String[] towns = new String[tokenCount];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String tmp = tokenizer.nextToken();
            towns[i++] = tmp;
        }
        while (tokenCount > 0) {
            String townName = "";
            int lastTokenCount = tokenCount;
            String words = "";
            for (int j = tokenCount; j > 0; --j) {
                words = "";
                for (i = 0; i < j; ++i) {
                    words = words + " " + towns[i].toString().trim();
                }
                if (!NZL_CityNames.isMultiWordAreaName(words.toString().trim()) && !NZL_CityNames.isPossibleMultiWordAreaName(words.toString().trim())) continue;
                for (i = 0; i < j; ++i) {
                    townName = townName + towns[i] + " ";
                }
                if ((tokenCount -= j) <= 0) break;
                String[] towns1 = new String[tokenCount];
                for (i = 0; i < tokenCount; ++i) {
                    towns1[i] = towns[j + i];
                }
                towns = towns1;
                break;
            }
            if (lastTokenCount == tokenCount) {
                townName = towns[0];
                if (--tokenCount > 0) {
                    String[] towns1 = new String[tokenCount];
                    for (i = 0; i < tokenCount; ++i) {
                        towns1[i] = towns[i + 1];
                    }
                    towns = towns1;
                }
            }
            if (pa.getAreaName4() == null && townName != null && !StringUtilities.isNumeric((String)townName)) {
                pa.setAreaName4(townName.trim());
                townName = null;
                continue;
            }
            if (pa.getAreaName3() != null || townName == null || StringUtilities.isNumeric((String)townName)) continue;
            pa.setAreaName3(townName.trim());
        }
    }

    public static String removeCommonWords(String inTown) {
        if (inTown == null || inTown.trim().length() == 0) {
            return null;
        }
        StringBuffer outTown = new StringBuffer();
        StringTokenizer st = new StringTokenizer(inTown, " ()/.,\\-'_", true);
        char lastPunctuation = '\u0000';
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.length() == 1) {
                if (!NZL_AddressTerm.isPunctuation(temp.charAt(0))) continue;
                if (lastPunctuation != temp.charAt(0)) {
                    outTown.append(temp);
                }
                lastPunctuation = temp.charAt(0);
                continue;
            }
            if (NZL_Abbreviations.isCommonTerm(temp)) continue;
            outTown.append(temp);
            lastPunctuation = '\u0000';
        }
        String shortTown = outTown.toString().trim();
        if (shortTown.length() > 0) {
            while (shortTown.length() > 0 && NZL_AddressTerm.isPunctuation(shortTown.substring(0, 1))) {
                shortTown = shortTown.substring(1);
            }
        }
        if (shortTown.length() == 0) {
            return null;
        }
        return shortTown;
    }

    private String padWithLeadingZeros(String postCode) {
        if (postCode.length() >= 4) {
            return postCode;
        }
        StringBuffer padded = new StringBuffer(4);
        for (int i = 0; i < 4 - postCode.length(); ++i) {
            padded.append("0");
        }
        padded.append(postCode);
        return padded.toString();
    }
}

