/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.reverseGeocode;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.IReverseGeocodeCandidate;
import com.mapinfo.mapmarker.core.reverseGeocode.CoreStandardReverseGeocodeSubHandler2;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class NZL_StandardReverseGeocodeSubHandler
extends CoreStandardReverseGeocodeSubHandler2 {
    private static final double FILTER_TOLERANCE = 1.0;

    protected List<CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder> filterCandidates(ReverseGeocodeLocation originalLocation, IReverseGeocodeInternalConstraints constraints, List<IReverseGeocodeCandidate> allCandidates) throws MapMarkerInternalException {
        double maxDist = originalLocation.getDistanceAsLength().getValue(LinearUnit.METER);
        ArrayList<ReverseGeocodeCandidate> filteredCandidates = new ArrayList<ReverseGeocodeCandidate>(1);
        IReverseGeocodeCandidate lastCandidate = null;
        for (IReverseGeocodeCandidate candidate : allCandidates) {
            if (candidate.getDistance() > maxDist) break;
            if (lastCandidate == null) {
                lastCandidate = candidate;
            } else if (candidate.getDistance() > lastCandidate.getDistance() + 1.0) break;
            candidate.matchAddressNumber(originalLocation, (IReverseGeocodeConstraints)constraints);
            ReverseGeocodeCandidate reverseGeocodeCandidate = new ReverseGeocodeCandidate(candidate, candidate.toCandidateAddress(originalLocation, (IReverseGeocodeConstraints)constraints));
            if (filteredCandidates.size() > 0) {
                ReverseGeocodeCandidateAddress firstCandidate = ((ReverseGeocodeCandidate)filteredCandidates.get(0)).getOutputCandidate();
                if (StringUtilities.isEmpty((String)firstCandidate.getAddressNumber()) && !StringUtilities.isEmpty((String)reverseGeocodeCandidate.getOutputCandidate().getAddressNumber()) && StringUtilities.equalStrings((String)reverseGeocodeCandidate.getOutputCandidate().getMainAddress(), (String)firstCandidate.getMainAddress())) {
                    filteredCandidates.remove(0);
                    filteredCandidates.add(reverseGeocodeCandidate);
                    continue;
                }
                if (!reverseGeocodeCandidate.getOutputCandidate().getDistance().equals((Object)firstCandidate.getDistance()) && !StringUtilities.equalStrings((String)reverseGeocodeCandidate.getOutputCandidate().getMainAddress(), (String)firstCandidate.getMainAddress())) continue;
                filteredCandidates.add(reverseGeocodeCandidate);
                continue;
            }
            filteredCandidates.add(reverseGeocodeCandidate);
        }
        this.filterBasedOnStreetSide(filteredCandidates, originalLocation, constraints);
        ArrayList<CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder> returnCandidates = new ArrayList<CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder>(1);
        for (IReverseGeocodeCandidate iReverseGeocodeCandidate : filteredCandidates) {
            returnCandidates.add(new CoreStandardReverseGeocodeSubHandler2.RGCandidateHolder(((ReverseGeocodeCandidate)iReverseGeocodeCandidate).getOutputCandidate(), iReverseGeocodeCandidate.getUserDictionaryPriority()));
        }
        return returnCandidates;
    }

    private static class ReverseGeocodeCandidate
    implements IReverseGeocodeCandidate {
        private final IReverseGeocodeCandidate m_candidate;
        private ReverseGeocodeCandidateAddress m_outCandidate;

        public ReverseGeocodeCandidate(IReverseGeocodeCandidate candidate, ReverseGeocodeCandidateAddress outCandidate) {
            this.m_candidate = candidate;
            this.m_outCandidate = outCandidate;
        }

        public ReverseGeocodeCandidateAddress getOutputCandidate() {
            return this.m_outCandidate;
        }

        public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
            return this.m_candidate.toCandidateAddress(location, constraints);
        }

        public double getDistance() {
            return this.m_candidate.getDistance();
        }

        public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
            this.m_candidate.matchAddressNumber(location, constraints);
        }

        public boolean isFromCorrectStreetSide(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
            return this.m_candidate.isFromCorrectStreetSide(location, constraints);
        }

        public int getUserDictionaryPriority() {
            return this.m_candidate.getUserDictionaryPriority();
        }

        public boolean matchesLocale(Locale loc) {
            return this.m_candidate.matchesLocale(loc);
        }

        public boolean isDefaultLocale() {
            return this.m_candidate.isDefaultLocale();
        }
    }
}

