/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.regex.Pattern;

public class NZL_PreferCOIndicatorInMainRule
implements Comparator<IAddressParsing> {
    private static Pattern CARE_OF_PATTERN = Pattern.compile(".*\\b[Cc]/.*");

    @Override
    public int compare(IAddressParsing ap1, IAddressParsing ap2) {
        boolean bCOInPost2;
        boolean bCOInMain2;
        boolean bCOInMain1 = this.mainHasCO(ap1.getSplit().getAddress());
        if (bCOInMain1 == (bCOInMain2 = this.mainHasCO(ap2.getSplit().getAddress()))) {
            return 0;
        }
        boolean bCOInPost1 = this.postHasCO(ap1.getSplit().getAddress());
        if (bCOInPost1 == (bCOInPost2 = this.postHasCO(ap2.getSplit().getAddress()))) {
            return 0;
        }
        if (bCOInMain1 && bCOInPost2) {
            return -1;
        }
        if (bCOInPost1 && bCOInMain2) {
            return 1;
        }
        return 0;
    }

    private boolean mainHasCO(Address address) {
        if (StringUtilities.isEmpty((String)address.getMainAddress())) {
            return false;
        }
        return CARE_OF_PATTERN.matcher(address.getMainAddress()).matches();
    }

    private boolean postHasCO(Address address) {
        if (StringUtilities.isEmpty((String)address.getPostAddress())) {
            return false;
        }
        return CARE_OF_PATTERN.matcher(address.getPostAddress()).matches();
    }
}

