/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.regex.Pattern;

public class NZL_PreferRDInMainAddressSplitRule
implements Comparator<IAddressParsing> {
    private static Pattern RD_PATTERN = Pattern.compile(".*\\b[Rr][Dd]\\b.*|.*\\b[Rr][Dd]\\d*\\b.*");

    @Override
    public int compare(IAddressParsing ap1, IAddressParsing ap2) {
        boolean postHas2;
        boolean mainHas2;
        boolean mainHas1 = this.mainHasRD(ap1.getSplit().getAddress());
        if (mainHas1 == (mainHas2 = this.mainHasRD(ap2.getSplit().getAddress()))) {
            return 0;
        }
        boolean postHas1 = this.postHasRD(ap1.getSplit().getAddress());
        if (postHas1 == (postHas2 = this.postHasRD(ap2.getSplit().getAddress()))) {
            return 0;
        }
        if (mainHas1 && postHas2) {
            return -1;
        }
        if (mainHas2 && postHas1) {
            return 1;
        }
        return 0;
    }

    private boolean mainHasRD(Address address) {
        return !StringUtilities.isEmpty((String)address.getMainAddress()) && RD_PATTERN.matcher(address.getMainAddress()).matches();
    }

    private boolean postHasRD(Address address) {
        return !StringUtilities.isEmpty((String)address.getPostAddress()) && RD_PATTERN.matcher(address.getPostAddress()).matches();
    }
}

