/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class SWELanguageSoundex
extends Soundex {
    protected static char[] letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '+', '\u00e7', '\u00f1', '\u00e0', '\u00e1', '\u00e4', '\u00e2', '\u00e3', '\u00e9', '\u00e8', '\u00eb', '\u00ea', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f2', '\u00fe', '\u00f4', '\u00f5', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00c7', '\u00d1', '\u00c1', '\u00c9', '\u00c3', '\u00cd', '\u00d3', '\u00da', '\u00ba', '\u00aa', '\u00d5', '\u0110', '\u00d0'};
    protected static int[] sounds = new int[]{0, 1, 2, 3, 0, 1, 2, 0, 0, 2, 2, 4, 5, 5, 0, 1, 2, 6, 2, 3, 0, 1, 0, 2, 0, 2, 0, 0, 2, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static String soundStr = "0250000000000000000000000500000000000000000001111222222223345560";
    protected static String charStr = "+\u00e7\u00f1\u00e0\u00e1\u00e4\u00e2\u00e3\u00e9\u00e8\u00eb\u00ea\u00ec\u00ed\u00ee\u00ef\u00f2\u00fe\u00f4\u00f5\u00f9\u00fa\u00fb\u00fc\u00c7\u00d1\u00c1\u00c9\u00c3\u00cd\u00d3\u00da\u00ba\u00aa\u00d5\u0110\u00d0AEHIOUWYBFPVCGJKQSXZDTLMNR\u00c4";
    protected static String DIGITS = "0123456789";
    protected static String VALID_CODES = "123456";
    protected static int SPECIAL_CASE_INITIALDIGIT = 1;
    protected Hashtable soundHash = new Hashtable(sounds.length);
    protected Properties specialChars;
    protected int MAX_SOUNDEX_KEY_LENGTH;
    protected static String[] ignoredWordList = new String[0];

    public SWELanguageSoundex() {
        for (int i = 0; i < sounds.length; ++i) {
            this.soundHash.put(new Character(letters[i]), new Integer(sounds[i]));
        }
        this.MAX_SOUNDEX_KEY_LENGTH = 9;
        this.loadSpecialChars();
    }

    protected void loadSpecialChars() {
        try {
            this.specialChars = new Properties();
            this.specialChars.load(SWELanguageSoundex.class.getResourceAsStream("SWESpecialCharacters.properties"));
        }
        catch (FileNotFoundException fx) {
            throw new RuntimeException("Could not find SWESpecialCharacters.properties", fx);
        }
        catch (IOException iox) {
            throw new RuntimeException("Could not read SWESpecialCharacters.properties", iox);
        }
    }

    public ISoundexKey getSoundex(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (this.isSpecialCase(str) != 0) {
            return this.handleSpecialCases(str);
        }
        char[] inputStringArray = (str = this.removeUnwantedCharsAndWords(str)).toCharArray();
        if (inputStringArray.length == 0) {
            return null;
        }
        MiSoundexKey key = new MiSoundexKey();
        key.setFirstChar(inputStringArray[0]);
        int inputStringLength = inputStringArray.length;
        int returnCode = 0;
        int base = 1;
        int lastcode = 0;
        int sdx = 0;
        int i = 1;
        int soundexKeysAdded = 0;
        while (i < inputStringLength && soundexKeysAdded < this.MAX_SOUNDEX_KEY_LENGTH) {
            char c = inputStringArray[i];
            boolean bIncrement = true;
            Integer intKey = (Integer)this.soundHash.get(new Character(c));
            sdx = intKey == null ? 0 : intKey;
            boolean bVowel = false;
            if (sdx == 0) {
                bVowel = true;
                while (i < inputStringLength) {
                    if (Character.isDigit(c = inputStringArray[i++]) || (sdx = (intKey = (Integer)this.soundHash.get(new Character(c))) == null ? 0 : intKey) == 0) continue;
                    bIncrement = false;
                    break;
                }
            }
            if (sdx != lastcode || bVowel) {
                returnCode += base * sdx;
                base *= 10;
                lastcode = sdx;
                ++soundexKeysAdded;
            }
            if (!bIncrement) continue;
            ++i;
        }
        key.setNumericValue(returnCode);
        return key;
    }

    protected int isSpecialCase(String str) {
        char firstChar = str.charAt(0);
        if (Character.isDigit(firstChar)) {
            return SPECIAL_CASE_INITIALDIGIT;
        }
        return 0;
    }

    protected ISoundexKey handleSpecialCases(String str) {
        char firstChar = str.charAt(0);
        if (Character.isDigit(firstChar)) {
            int code;
            try {
                Integer tmp = new Integer(StringUtilities.trimToChars((String)str, (String)DIGITS));
                code = tmp;
            }
            catch (NumberFormatException e) {
                code = 0;
            }
            MiSoundexKey key = new MiSoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(code);
            return key;
        }
        return null;
    }

    protected RemoveWordResult removeWord(String str, String word) {
        RemoveWordResult ret = new RemoveWordResult();
        ret.retStr = str;
        ret.found = 0;
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        if (str.indexOf(word) == -1) {
            return ret;
        }
        int wordLength = word.length();
        while (str.startsWith(word + ' ')) {
            ret.retStr = str = str.substring(wordLength + 1);
            ret.found = 1;
        }
        while (str.endsWith(' ' + word)) {
            ret.retStr = str = str.substring(0, str.length() - wordLength - 1);
            ret.found = 1;
        }
        int pos = str.indexOf(' ' + word + ' ');
        while (pos > -1) {
            str = str.substring(0, pos) + str.substring(pos + wordLength + 1);
            pos = str.indexOf(' ' + word + ' ');
            ret.retStr = str;
            ret.found = 1;
        }
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        return ret;
    }

    protected String removeUnwantedCharsAndWords(String str) {
        int i;
        str.trim();
        if (str.indexOf(" ") != -1) {
            int len = ignoredWordList.length;
            for (i = 0; i < len; ++i) {
                RemoveWordResult ret = this.removeWord(str, ignoredWordList[i]);
                str = ret.retStr;
                if (ret.found < 0) break;
            }
        }
        char[] tempArray = str.toCharArray();
        StringBuffer returnBuffer = new StringBuffer(str.length());
        for (i = 0; i < tempArray.length; ++i) {
            char c = tempArray[i];
            String s = String.valueOf(c);
            if (!Character.isLetterOrDigit(c)) continue;
            if (this.specialChars.containsKey(s)) {
                returnBuffer.append(this.specialChars.getProperty(s));
                continue;
            }
            returnBuffer.append(c);
        }
        return returnBuffer.toString();
    }

    public List calculateAlternateSoundexKeys(String origString, ISoundexKey origKey, int possibleErrors, List keys) {
        int val;
        int j;
        StringBuffer sb;
        MiSoundexKey key;
        char c;
        int i;
        int end;
        char sound;
        int idx;
        if (possibleErrors == 0) {
            return keys;
        }
        if (origString == null || origString.length() == 0) {
            return keys;
        }
        int type = this.isSpecialCase(origString);
        if (type == SPECIAL_CASE_INITIALDIGIT) {
            return keys;
        }
        origString = this.removeUnwantedCharsAndWords(origString);
        char firstChar = ((MiSoundexKey)origKey).getFirstChar();
        int origNumericVal = ((MiSoundexKey)origKey).getNumericValue();
        if ((possibleErrors & 0x20) > 0) {
            // empty if block
        }
        if ((possibleErrors & 1) > 0 && (idx = charStr.indexOf(firstChar)) >= 0) {
            sound = soundStr.charAt(idx);
            end = soundStr.lastIndexOf(sound) + 1;
            for (i = soundStr.indexOf(sound); i < end; ++i) {
                c = charStr.charAt(i);
                if (c == firstChar) continue;
                key = new MiSoundexKey();
                key.setNumericValue(origNumericVal);
                key.setFirstChar(c);
                if (key == null || keys.contains(key)) continue;
                keys.add(key);
            }
        }
        if ((possibleErrors & 2) > 0) {
            int len = origString.length();
            StringBuffer nameBuf = new StringBuffer(origString);
            for (i = 1; i < len; ++i) {
                c = nameBuf.charAt(i);
                idx = charStr.indexOf(c);
                if (idx < 0 || (sound = soundStr.charAt(charStr.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                if (key != null && !keys.contains(key)) {
                    keys.add(key);
                }
                nameBuf.setCharAt(i, c);
            }
        }
        if ((possibleErrors & 4) > 0) {
            String code = String.valueOf(origNumericVal);
            int len = code.length();
            end = VALID_CODES.length();
            sb = new StringBuffer(len);
            for (i = 0; i < len; ++i) {
                for (j = 0; j < end; ++j) {
                    if (code.charAt(i) == VALID_CODES.charAt(j)) continue;
                    sb.delete(0, len);
                    sb.append(code);
                    sb.replace(i, i + 1, new String("" + VALID_CODES.charAt(j)));
                    key = new MiSoundexKey();
                    key.setFirstChar(firstChar);
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        if ((possibleErrors & 8) > 0) {
            String code = String.valueOf(origNumericVal);
            int len = code.length();
            if (len == this.MAX_SOUNDEX_KEY_LENGTH) {
                code = code.substring(1);
                --len;
            }
            end = VALID_CODES.length();
            sb = new StringBuffer(len + 1);
            for (i = 0; i < len + 1; ++i) {
                for (j = 0; j < end; ++j) {
                    sb.delete(0, len + 1);
                    sb.append(code);
                    sb.insert(i, VALID_CODES.charAt(j));
                    key = new MiSoundexKey();
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    key.setFirstChar(firstChar);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        if ((possibleErrors & 0x10) > 0) {
            String code = String.valueOf(origNumericVal);
            int len = code.length() - 1;
            sb = new StringBuffer(len + 1);
            sb.append(code);
            for (i = 0; i < len; ++i) {
                char c1 = sb.charAt(i);
                char c2 = sb.charAt(i + 1);
                sb.setCharAt(i, c2);
                sb.setCharAt(i + 1, c1);
                key = new MiSoundexKey();
                val = Integer.parseInt(sb.toString());
                key.setNumericValue(val);
                key.setFirstChar(firstChar);
                if (!keys.contains(key)) {
                    keys.add(key);
                }
                sb.setCharAt(i, c1);
                sb.setCharAt(i + 1, c2);
            }
        }
        return keys;
    }

    public static void main(String[] args) {
        int j;
        int len;
        List list;
        String value;
        ISoundexKey key;
        String test;
        int i;
        SWELanguageSoundex soundex = new SWELanguageSoundex();
        String[] tests = new String[]{"\u00d6stermalm ", "Ostermalm "};
        for (i = 0; i < tests.length; ++i) {
            test = tests[i];
            key = soundex.getSoundex(test);
            value = key.toString();
            System.out.println("\nTest: " + test + "\tValue: " + value + " input first char: " + test.charAt(0));
            list = new ArrayList();
            list = soundex.calculateAlternateSoundexKeys(test, key, 255, list);
            len = list.size();
            for (j = 0; j < len; ++j) {
                System.out.println("\nOutput: " + test + "\t alternate " + (ISoundexKey)list.get(j));
            }
        }
        for (i = 0; i < args.length; ++i) {
            test = args[i];
            key = soundex.getSoundex(test);
            value = key.toString();
            System.out.println("\nInput: " + test + "\tValue: " + value + " input first char: " + test.charAt(0));
            list = new ArrayList();
            list = soundex.calculateAlternateSoundexKeys(test, key, 255, list);
            len = list.size();
            for (j = 0; j < len; ++j) {
                System.out.println("\nOutput: " + test + "\t alternate " + (ISoundexKey)list.get(j));
            }
        }
    }

    public static ISoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        MiSoundexKey mikey = new MiSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    public static void turnOffErrorHandling(IConstraints constraints) {
        constraints.removeCustomObject((Object)"input_correction_error");
        constraints.setCustomObject((Object)"input_correction_active", (Object)new Boolean(false));
    }

    public static void turnOnErrorHandling(IConstraints constraints) {
        constraints.setCustomObject((Object)"input_correction_active", (Object)new Boolean(true));
        constraints.setCustomObject((Object)"input_correction_checked", new ArrayList());
    }

    protected class RemoveWordResult {
        String retStr;
        int found;

        protected RemoveWordResult() {
        }
    }
}

