/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.geographic.ICoreGeographicCentroidFilter;
import com.mapinfo.mapmarker.core.geographic.IGeographicCentroidFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SWE_GeographicCentroidFilter
implements IGeographicCentroidFilter {
    public List filterGeographicCloseMatches(IHandler handler) {
        Address[] inputAddresses = handler.getParsedAddressArray();
        List geographicCandidates = handler.getMatchResults();
        ICloseMatchFilterRule[] closeMatchRules = ((ICoreGeographicCentroidFilter)handler).getGeographicCentroidFilterRules();
        if (closeMatchRules == null) {
            return geographicCandidates;
        }
        boolean resort = false;
        Iterator bestCandidateIterator = geographicCandidates.iterator();
        while (bestCandidateIterator.hasNext()) {
            InternalGeographicCandidate otherCandidate = null;
            boolean bGetNextBestCandidate = false;
            boolean bGetNextOtherCandidate = true;
            InternalGeographicCandidate bestCandidate = (InternalGeographicCandidate)bestCandidateIterator.next();
            if (!bestCandidate.isCloseMatch()) continue;
            Iterator otherCandidateIterator = geographicCandidates.iterator();
            while (otherCandidateIterator.hasNext() && bGetNextOtherCandidate) {
                otherCandidate = (InternalGeographicCandidate)otherCandidateIterator.next();
                if (otherCandidate != bestCandidate) continue;
                bGetNextOtherCandidate = false;
            }
            while (otherCandidateIterator.hasNext() && !bGetNextBestCandidate) {
                otherCandidate = (InternalGeographicCandidate)otherCandidateIterator.next();
                if (!otherCandidate.isCloseMatch()) continue;
                boolean bGetNextCandidate = false;
                for (int i = 0; i < closeMatchRules.length && !bGetNextCandidate; ++i) {
                    if (closeMatchRules[i].demoteOther(inputAddresses, (ICandidate)bestCandidate, (ICandidate)otherCandidate)) {
                        resort = true;
                        otherCandidate.setCloseMatchStatus(false);
                        bGetNextCandidate = true;
                        continue;
                    }
                    if (!closeMatchRules[i].demoteOther(inputAddresses, (ICandidate)otherCandidate, (ICandidate)bestCandidate)) continue;
                    resort = true;
                    bestCandidate.setCloseMatchStatus(false);
                    bGetNextCandidate = true;
                    bGetNextBestCandidate = true;
                }
            }
        }
        if (resort) {
            Collections.reverse(geographicCandidates);
            Collections.sort(geographicCandidates);
            Collections.reverse(geographicCandidates);
        }
        return geographicCandidates;
    }
}

