/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.SWE_Range;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.List;

public class SWE_InternalCandidateAddress
extends InternalCandidateAddress {
    private boolean m_bSwappedArea3and4scores = false;
    private static final double ALTERNATE_SCORING_THRESHOLD = 0.7;
    private static final double SWAP_AREA_34_SCORING_THRESHOLD = 0.8;
    private static final double ATTEMPT_SWAP_AREA_34_THRESHOLD = 1.0;
    private boolean m_adjustS4;
    public static final String POST_STREET_TYPE_SEPARATOR = "POST_STREET_TYPE_SEPARATOR";
    int matchedAltAreaName1Index = -1;
    int matchedAltAreaName2Index = -1;
    int matchedAltAreaName3Index = -1;
    int matchedAltAreaName4Index = -1;

    public SWE_InternalCandidateAddress() {
    }

    public SWE_InternalCandidateAddress(Address addr) {
        super(addr);
        if (addr instanceof SWE_InternalCandidateAddress) {
            this.matchedAltAreaName1Index = ((SWE_InternalCandidateAddress)addr).matchedAltAreaName1Index;
            this.matchedAltAreaName2Index = ((SWE_InternalCandidateAddress)addr).matchedAltAreaName2Index;
            this.matchedAltAreaName3Index = ((SWE_InternalCandidateAddress)addr).matchedAltAreaName3Index;
            this.matchedAltAreaName4Index = ((SWE_InternalCandidateAddress)addr).matchedAltAreaName4Index;
        }
    }

    public void scoreAreaNames(ScoringAddress scoringAddress) {
        super.scoreAreaNames(scoringAddress);
        this.scoreAlternateAreaName1(scoringAddress);
        this.scoreAlternateAreaName2(scoringAddress);
        this.scoreAlternateAreaName3(scoringAddress);
        this.scoreAlternateAreaName4(scoringAddress);
        double an3score = this.getAreaName3Score();
        if (an3score < 1.0 && !StringUtilities.isEmpty((String)scoringAddress.getAreaName3()) && StringUtilities.isEmpty((String)scoringAddress.getAreaName4())) {
            double an3as4score = scoringAddress.scoreAreaName4(this.getAreaName3());
            double an4as3score = scoringAddress.scoreAreaName3(this.getAreaName4());
            if (an3as4score > 0.8 || an4as3score > 0.8) {
                this.setAreaName3Score(an4as3score);
                this.setAreaName4Score(an3as4score);
                this.m_bSwappedArea3and4scores = true;
                return;
            }
        }
        if (an3score != 1.0) {
            int idx;
            String in = scoringAddress.getAreaName3();
            double an4currentScore = this.getAreaName4Score();
            double an2currentScore = this.getAreaName2Score();
            String an3 = this.getAreaName3();
            if (!StringUtilities.isEmpty((String)in) && !StringUtilities.isEmpty((String)an3) && (idx = in.indexOf(an3)) >= 0) {
                double an2newScore;
                String poss = in.replace(an3, "").trim();
                double an4newScore = scoringAddress.getStringScorer().scoreString(poss, this.getAreaName4());
                if (an4newScore > (an2newScore = scoringAddress.getStringScorer().scoreString(poss, this.getAreaName2())) && an4newScore > an4currentScore) {
                    this.setAreaName4Score(an4newScore);
                    this.setAreaName3Score(1.0);
                } else if (an2newScore > an4newScore && an2newScore > an2currentScore) {
                    this.setAreaName2Score(an2newScore);
                    this.setAreaName3Score(1.0);
                }
            }
        }
    }

    public String getFormattedLocationAddress() {
        StringBuilder sb = new StringBuilder();
        SWE_GeoInfoRecord record = (SWE_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        String postcode = this.getPostCode1();
        sb.append(SWE_AddressUtils.adjustPostCodeFormatting(postcode, postcode));
        sb.append(' ');
        if (record != null && this.matchedAltAreaName3Index >= 0) {
            sb.append(record.getAltAreaName3Array()[this.matchedAltAreaName3Index]);
        } else {
            sb.append(this.getAreaName3());
        }
        return sb.toString();
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candidate;
        String addrNum = this.getAddressNumber();
        if (addrNum != null && StringUtilities.isNumeric((String)addrNum) && StringUtilities.equalStrings((String)addrNum, (String)input.getAddressNumber())) {
            long addressAsNumber = Long.parseLong(addrNum);
            int matchedRange = this.getMatchedRangeNumber();
            int side = this.getSegmentSide();
            if (matchedRange >= 0) {
                Range range = this.getSegment().getRangeAt(matchedRange, side);
                ParsedNumber from = range.getParsedFrom();
                ParsedNumber to = range.getParsedTo();
                if (!from.isPureNumeric() && addressAsNumber == from.getAddressNumber()) {
                    range.setMatchedRangeNumber(from);
                } else if (!to.isPureNumeric() && addressAsNumber == to.getAddressNumber()) {
                    range.setMatchedRangeNumber(to);
                }
            }
        }
        double old = this.getAdditionalParserFieldsScore();
        if (this.getPreDirectionalScore() == 1.0) {
            this.setAdditionalParserFieldsScore(2.0);
        }
        if ((candidate = super.toCandidateAddress(input, constraints)).getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)candidate.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            this.m_adjustS4 = true;
            candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
            candidate.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        this.setAdditionalParserFieldsScore(old);
        String postcode = candidate.getPostCode1();
        candidate.setPostCode1(SWE_AddressUtils.adjustPostCodeFormatting(postcode, postcode));
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        SWE_GeoInfoRecord geoInfoRecord = (SWE_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        if (geoInfoRecord != null) {
            if (this.matchedAltAreaName1Index >= 0) {
                candidate.setAreaName1(geoInfoRecord.getAltAreaName1Array()[this.matchedAltAreaName1Index]);
            }
            if (this.matchedAltAreaName2Index >= 0) {
                candidate.setAreaName2(geoInfoRecord.getAltAreaName2Array()[this.matchedAltAreaName2Index]);
            }
            if (this.matchedAltAreaName3Index >= 0) {
                candidate.setAreaName3(geoInfoRecord.getAltAreaName3Array()[this.matchedAltAreaName3Index]);
            }
            if (this.matchedAltAreaName4Index >= 0) {
                candidate.setAreaName4(geoInfoRecord.getAltAreaName4Array()[this.matchedAltAreaName4Index]);
            }
        }
        candidate.getAdditionalFields().remove(POST_STREET_TYPE_SEPARATOR);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return candidate;
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        ReverseGeocodeCandidateAddress candidate = super.toCandidateAddress(location, constraints);
        candidate.setFormattedLocationAddress(SWE_AddressUtils.adjustPostCodeFormatting(candidate.getFormattedLocationAddress(), candidate.getPostCode1()));
        String postcode = candidate.getPostCode1();
        candidate.setPostCode1(SWE_AddressUtils.adjustPostCodeFormatting(postcode, postcode));
        candidate.getAdditionalFields().remove(POST_STREET_TYPE_SEPARATOR);
        return candidate;
    }

    public String getPostCode1() {
        String right;
        String left;
        Segment segment;
        String postCode1 = super.getPostCode1();
        if (postCode1 == null && (segment = this.getSegment()) != null && StringUtilities.equalStrings((String)(left = segment.getLeftPostCode1()), (String)(right = segment.getRightPostCode1()))) {
            return left;
        }
        return postCode1;
    }

    public String getAreaName3() {
        Segment segment;
        String areaName3 = super.getAreaName3();
        if (areaName3 == null && (segment = this.getSegment()) != null) {
            String right;
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName3();
            }
            String left = segment.getLeftAreaName3();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName3()))) {
                return left;
            }
        }
        return areaName3;
    }

    public String getAreaName4() {
        Segment segment;
        String areaName4 = super.getAreaName4();
        if (areaName4 == null && (segment = this.getSegment()) != null) {
            String right;
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName4();
            }
            String left = segment.getLeftAreaName4();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName4()))) {
                return left;
            }
        }
        return areaName4;
    }

    public String getAreaName2() {
        Segment segment;
        String areaName2 = super.getAreaName2();
        if (areaName2 == null && (segment = this.getSegment()) != null) {
            String right;
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName2();
            }
            String left = segment.getLeftAreaName2();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName2()))) {
                return left;
            }
        }
        return areaName2;
    }

    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegment()) != null) {
            String right;
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName1();
            }
            String left = segment.getLeftAreaName1();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName1()))) {
                return left;
            }
        }
        return areaName1;
    }

    public String getFormattedStreetAddress() {
        String addrNum;
        String postAddr;
        String postTT;
        String newMainAddress;
        String unparsedAddress = this.getGenericField4();
        if (unparsedAddress != null && unparsedAddress.length() > 0) {
            return unparsedAddress;
        }
        HashMap fields = this.getAdditionalFields();
        StringBuilder buf = new StringBuilder();
        String preDir = this.getPreDirectional();
        if (!StringUtilities.isEmpty((String)preDir)) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((newMainAddress = this.getMainAddress()) != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress);
        }
        if ((postTT = this.getPostThoroughfareType()) != null && postTT.length() != 0) {
            String postStrTypeSep = (String)fields.get(POST_STREET_TYPE_SEPARATOR);
            if (postStrTypeSep != null && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postTT);
        }
        if ((postAddr = this.getPostAddress()) != null && postAddr.length() != 0) {
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postAddr);
        }
        if ((addrNum = this.getAddressNumber()) == null && postAddr == null && this.m_adjustS4) {
            addrNum = this.getInputNumber().getCombinedAddressNumber();
        }
        if (addrNum != null && addrNum.length() != 0) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != ' ') {
                buf.append(' ');
            }
            buf.append(addrNum);
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        boolean bThatEmpty;
        if (!super.equals(other)) {
            return false;
        }
        SWE_InternalCandidateAddress otherCand = (SWE_InternalCandidateAddress)((Object)other);
        boolean bThisEmpty = StringUtilities.isEmpty((String)this.getAreaName4());
        if (bThisEmpty != (bThatEmpty = StringUtilities.isEmpty((String)otherCand.getAreaName4()))) {
            return false;
        }
        return StringUtilities.equalStrings((String)this.getPreDirectional(), (String)otherCand.getPreDirectional());
    }

    public int compareTo(Object o2) {
        int res = super.compareTo(o2);
        if (res == 0) {
            SWE_InternalCandidateAddress thatCandidate = (SWE_InternalCandidateAddress)((Object)o2);
            if (this.getAreaName4Score() == thatCandidate.getAreaName4Score()) {
                boolean bThatEmpty;
                boolean bThisEmpty = StringUtilities.isEmpty((String)this.getAreaName4());
                if (bThisEmpty != (bThatEmpty = StringUtilities.isEmpty((String)((SWE_InternalCandidateAddress)((Object)o2)).getAreaName4()))) {
                    if (bThisEmpty) {
                        return 1;
                    }
                    return -1;
                }
            } else {
                if (this.getAreaName4Score() > thatCandidate.getAreaName4Score()) {
                    return 1;
                }
                return -1;
            }
            if (this.getPreDirectionalScore() > thatCandidate.getPreDirectionalScore()) {
                return 1;
            }
            if (thatCandidate.getPreDirectionalScore() > this.getPreDirectionalScore()) {
                return -1;
            }
            if (thatCandidate.getPreDirectionalScore() == this.getPreDirectionalScore() && this.getPreDirectionalScore() == 1.0) {
                if (this.getPreDirectional() != null && thatCandidate.getPreDirectional() == null) {
                    return 1;
                }
                if (this.getPreDirectional() == null && thatCandidate.getPreDirectional() != null) {
                    return -1;
                }
            }
        }
        return res;
    }

    protected boolean getMatchFlagForEmptyLocationFields() {
        return false;
    }

    protected void scoreAlternateAreaName1(ScoringAddress scoringAddress) {
        ScoreAndIndex info;
        SWE_GeoInfoRecord geoinfo = (SWE_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        if (geoinfo == null) {
            return;
        }
        double an1score = this.getAreaName1Score();
        if (an1score != 1.0 && (info = this.scoreAlternateAreaName(scoringAddress, an1score, scoringAddress.getAreaName1(), geoinfo.getAltAreaName1Array())) != null && info.index >= 0) {
            this.matchedAltAreaName1Index = info.index;
            this.setAreaName1Score(info.score);
        }
    }

    protected void scoreAlternateAreaName2(ScoringAddress scoringAddress) {
        ScoreAndIndex info;
        SWE_GeoInfoRecord geoinfo = (SWE_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        if (geoinfo == null) {
            return;
        }
        double an2score = this.getAreaName2Score();
        if (an2score != 1.0 && (info = this.scoreAlternateAreaName(scoringAddress, an2score, scoringAddress.getAreaName2(), geoinfo.getAltAreaName2Array())) != null && info.index >= 0) {
            this.matchedAltAreaName2Index = info.index;
            this.setAreaName2Score(info.score);
        }
    }

    protected void scoreAlternateAreaName3(ScoringAddress scoringAddress) {
        ScoreAndIndex info;
        SWE_GeoInfoRecord geoinfo = (SWE_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        if (geoinfo == null) {
            return;
        }
        double an3score = this.getAreaName3Score();
        if (an3score != 1.0 && (info = this.scoreAlternateAreaName(scoringAddress, an3score, scoringAddress.getAreaName3(), geoinfo.getAltAreaName3Array())) != null && info.index >= 0) {
            this.matchedAltAreaName3Index = info.index;
            this.setAreaName3Score(info.score);
        }
    }

    protected void scoreAlternateAreaName4(ScoringAddress scoringAddress) {
        ScoreAndIndex info;
        SWE_GeoInfoRecord geoinfo = (SWE_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        if (geoinfo == null) {
            return;
        }
        double an4score = this.getAreaName4Score();
        if (an4score != 1.0 && (info = this.scoreAlternateAreaName(scoringAddress, an4score, scoringAddress.getAreaName4(), geoinfo.getAltAreaName4Array())) != null && info.index >= 0) {
            this.matchedAltAreaName4Index = info.index;
            this.setAreaName4Score(info.score);
        }
    }

    protected double getHouseNumberPercentage(int segmentSide, int rangeNumber, ParsedNumber targetHouse) {
        int rangeCount = this.getSegment().getRangeCount(segmentSide);
        List ranges = this.getSegment().getRanges(segmentSide);
        long totalAddresses = 0L;
        long targetAddressPosition = -1L;
        for (int i = 0; i < rangeCount; ++i) {
            SWE_Range r = (SWE_Range)((Object)ranges.get(i));
            if (i == rangeNumber) {
                targetAddressPosition = r.isArtificialRange() ? (r.hasHouseForInterpolation() ? totalAddresses : (totalAddresses > 0L ? totalAddresses - 1L : totalAddresses)) : totalAddresses + r.computeOffsetInRange(targetHouse);
            }
            if (r.isArtificialRange()) {
                totalAddresses += r.hasHouseForInterpolation() ? 1L : 0L;
                continue;
            }
            totalAddresses += r.computeAddressesInRange();
        }
        return this.calculateSegmentPercentage(totalAddresses - 1L, targetAddressPosition);
    }

    private ScoreAndIndex scoreAlternateAreaName(ScoringAddress scoringAddress, double bestScore, String input, String[] alts) {
        ScoreAndIndex info = new ScoreAndIndex();
        if (alts != null) {
            for (int idx = 0; idx < alts.length; ++idx) {
                String alt = alts[idx];
                double altScore = scoringAddress.getStringScorer().scoreString(alt, input);
                if (!(altScore > bestScore) || !(altScore > 0.7)) continue;
                info.score = bestScore = altScore;
                info.index = idx;
                if (bestScore != 1.0) continue;
                return info;
            }
        }
        return info;
    }

    private class ScoreAndIndex {
        int index = -1;
        double score = 0.0;

        private ScoreAndIndex() {
        }
    }
}

