/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWE_ScoringHelper;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;

public class SWE_InternalGeographicCandidate
extends InternalGeographicCandidate {
    private static final double EXACT_CLOSE_MATCH_SCORE = 1.0;
    private static final double ALTERNATE_SCORING_THRESHOLD = 0.7;
    int matchedAltAreaName1Index = -1;
    int matchedAltAreaName2Index = -1;
    int matchedAltAreaName3Index = -1;
    int matchedAltAreaName4Index = -1;

    public SWE_InternalGeographicCandidate() {
        this.setStringScorer(SWE_ScoringHelper.getStringScorer());
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        CandidateAddress candidate = new CandidateAddress();
        candidate.setAreaName1(this.getAreaName1());
        candidate.setAreaName2(this.getAreaName2());
        candidate.setAreaName3(this.getAreaName3());
        candidate.setAreaName4(this.getAreaName4());
        SWE_GeoInfoRecord geoInfoRecord = (SWE_GeoInfoRecord)this.getGeoInfoRecord();
        if (geoInfoRecord != null) {
            if (this.matchedAltAreaName1Index >= 0) {
                candidate.setAreaName1(geoInfoRecord.getAltAreaName1Array()[this.matchedAltAreaName1Index]);
            }
            if (this.matchedAltAreaName2Index >= 0) {
                candidate.setAreaName2(geoInfoRecord.getAltAreaName2Array()[this.matchedAltAreaName2Index]);
            }
            if (this.matchedAltAreaName3Index >= 0) {
                candidate.setAreaName3(geoInfoRecord.getAltAreaName3Array()[this.matchedAltAreaName3Index]);
            }
            if (this.matchedAltAreaName4Index >= 0) {
                candidate.setAreaName4(geoInfoRecord.getAltAreaName4Array()[this.matchedAltAreaName4Index]);
            }
        }
        int precision = this.getPrecision();
        candidate.setCountry(this.getCountry());
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (inputAddress.getAreaName1() != null && this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (inputAddress.getAreaName2() != null && this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (inputAddress.getAreaName4() != null && this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getCentroid() != null) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)this.getCentroid()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        } else {
            candidate.setLocation(new DirectPosition());
        }
        candidate.setLocationPrecision(precision);
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        return candidate;
    }

    public String toString() {
        return "\nSWE_InternalGeographicCandidate:" + super.toString();
    }

    public void scoreAreaName3(Address inputAddress) {
        double tempScore;
        String[] alts;
        String in = inputAddress.getAreaName3();
        double an3score = this.getStringScorer().scoreString(this.getAreaName3(), in);
        this.setAreaName3Score(an3score);
        if (an3score != 1.0 && (alts = ((SWE_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName3Array()) != null && !StringUtilities.isEmpty((String)in)) {
            ScoreAndIndex scoreAndIndex = this.scoreAlternateAreaName(an3score, in, alts);
            this.setAreaName3Score(scoreAndIndex.score);
            this.matchedAltAreaName3Index = scoreAndIndex.index;
        }
        if (an3score == 1.0) {
            return;
        }
        if (this.getAreaName3Score() != 1.0 && this.getAreaName4() != null && (tempScore = this.getStringScorer().scoreString(this.getAreaName4(), inputAddress.getAreaName3())) > this.getAreaName3Score()) {
            this.setAreaName3Score(tempScore);
        }
    }

    public void scoreAreaName1(Address inputAddress) {
        String[] alts;
        String in = inputAddress.getAreaName1();
        double score = this.getStringScorer().scoreString(this.getAreaName1(), in);
        this.setAreaName1Score(score);
        if (score != 1.0 && (alts = ((SWE_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName1Array()) != null && !StringUtilities.isEmpty((String)in)) {
            ScoreAndIndex scoreAndIndex = this.scoreAlternateAreaName(score, in, alts);
            this.setAreaName1Score(scoreAndIndex.score);
            this.matchedAltAreaName1Index = scoreAndIndex.index;
        }
    }

    public void scoreAreaName2(Address inputAddress) {
        String[] alts;
        String in = inputAddress.getAreaName2();
        double score = this.getStringScorer().scoreString(this.getAreaName2(), in);
        this.setAreaName2Score(score);
        if (score != 1.0 && (alts = ((SWE_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName2Array()) != null && !StringUtilities.isEmpty((String)in)) {
            ScoreAndIndex scoreAndIndex = this.scoreAlternateAreaName(score, in, alts);
            this.setAreaName2Score(scoreAndIndex.score);
            this.matchedAltAreaName2Index = scoreAndIndex.index;
        }
    }

    public void scoreAreaName4(Address inputAddress) {
        String[] alts;
        String in = inputAddress.getAreaName4();
        double score = this.getStringScorer().scoreString(this.getAreaName4(), in);
        this.setAreaName4Score(score);
        if (score != 1.0 && (alts = ((SWE_GeoInfoRecord)this.getGeoInfoRecord()).getAltAreaName4Array()) != null && !StringUtilities.isEmpty((String)in)) {
            ScoreAndIndex scoreAndIndex = this.scoreAlternateAreaName(score, in, alts);
            this.setAreaName4Score(scoreAndIndex.score);
            this.matchedAltAreaName4Index = scoreAndIndex.index;
        }
    }

    private ScoreAndIndex scoreAlternateAreaName(double bestScore, String input, String[] alts) {
        int altIndex = -1;
        for (int idx = 0; idx < alts.length; ++idx) {
            String alt = alts[idx];
            double altScore = this.getStringScorer().scoreString(alt, input);
            if (!(altScore > bestScore) || !(altScore > 0.7)) continue;
            bestScore = altScore;
            altIndex = idx;
            if (bestScore == 1.0) break;
        }
        return new ScoreAndIndex(bestScore, altIndex);
    }

    private class ScoreAndIndex {
        int index = -1;
        double score = 0.0;

        public ScoreAndIndex(double score, int idx) {
            this.score = score;
            this.index = idx;
        }
    }
}

