/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.SWE_ScoringHelper;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SWE_ScoringAddress
extends ScoringAddress {
    public static final Set<String> VAGEN_TYPES;

    public SWE_ScoringAddress(Address addr) {
        this(addr, null, null, null);
    }

    public SWE_ScoringAddress(Address addr, Map mainAddrCache, Map areaNamesCache, Map generalCache) {
        super(addr, generalCache, generalCache, generalCache, generalCache, mainAddrCache, generalCache, generalCache, generalCache, areaNamesCache, areaNamesCache, areaNamesCache, areaNamesCache);
    }

    public double scoreAreaName3(String str) {
        if (str == null || this.getAreaName3() == null) {
            return 0.0;
        }
        return super.scoreAreaName3(str);
    }

    public double scoreAreaName4(String str) {
        if (str == null || this.getAreaName4() == null) {
            return 0.0;
        }
        return super.scoreAreaName4(str);
    }

    public double scorePreDirectional(String str) {
        if (this.getPreDirectional() == null && StringUtilities.isEmpty((String)str)) {
            return 1.0;
        }
        if (this.getPreDirectional() == null) {
            return 0.0;
        }
        if (str != null) {
            if (StringUtilities.equalStrings((String)SWE_AddressUtils.expandDirectional(str), (String)SWE_AddressUtils.expandDirectional(this.getPreDirectional()))) {
                return 1.0;
            }
            return 0.0;
        }
        return 1.0;
    }

    public StringScorer getStringScorer() {
        return SWE_ScoringHelper.getStringScorer();
    }

    public double scorePreThoroughfareType(String str) {
        return this.scoreSWEThoroughfareType(this.getPreThoroughfareType(), str);
    }

    public double scorePostCode1(String str) {
        String myPostcode = this.getPostCode1();
        if (myPostcode == null) {
            if (str == null) {
                return 1.0;
            }
            return 0.0;
        }
        if (str == null) {
            return 0.0;
        }
        if (myPostcode.equals(str)) {
            return 1.0;
        }
        try {
            int p1 = Integer.parseInt(myPostcode);
            int numZeros = 5 - myPostcode.length();
            while (numZeros-- > 0) {
                p1 *= 10;
            }
            int p2 = Integer.parseInt(str);
            numZeros = 5 - str.length();
            while (numZeros-- > 0) {
                p2 *= 10;
            }
            return (p1 / 10000 == p2 / 10000 ? 0.26 : 0.0) + (p1 % 10000 / 1000 == p2 % 10000 / 1000 ? 0.23 : 0.0) + (p1 % 1000 / 100 == p2 % 1000 / 100 ? 0.2 : 0.0) + (p1 % 100 / 10 == p2 % 100 / 10 ? 0.17 : 0.0) + (p1 % 10 == p2 % 10 ? 0.14 : 0.0);
        }
        catch (NumberFormatException nex) {
            return super.scorePostCode1(str);
        }
    }

    public double scorePostThoroughfareType(String str) {
        return this.scoreSWEThoroughfareType(this.getPostThoroughfareType(), str);
    }

    private double scoreSWEThoroughfareType(String sourceTTStr, String targetTTStr) {
        double score = this.getStringScorer().scoreString(sourceTTStr, targetTTStr);
        if (score < 1.0 && targetTTStr != null && sourceTTStr != null && targetTTStr.charAt(0) != sourceTTStr.charAt(0)) {
            score /= 2.0;
        }
        if (score != 1.0 && SWE_AddressUtils.isSharedStreetTypes(sourceTTStr, targetTTStr)) {
            return 1.0;
        }
        return score;
    }

    public double scorePostAddress(String postAddress) {
        HashMap fields;
        double score = 0.0;
        score = super.scorePostAddress(postAddress);
        if (score != 1.0 && (fields = this.getAdditionalFields()) != null) {
            String inputPostAddr = (String)fields.get("street_suffix");
            if (postAddress != null && inputPostAddr != null) {
                score = super.doScore(postAddress, inputPostAddr, null);
                inputPostAddr = null;
            }
        }
        return score;
    }

    static {
        HashSet<String> tmp = new HashSet<String>(4);
        tmp.add("VAG");
        tmp.add("VAGEN");
        tmp.add("V\u00c4GEN");
        tmp.add("V\u00c4G");
        VAGEN_TYPES = Collections.unmodifiableSet(tmp);
    }
}

