/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.browse;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWE_InternalBrowseAddress;
import com.mapinfo.mapmarker.SWE.browse.BrowseAddressComparator;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SWE_BrowseFilter
implements IBrowseFilter {
    public List filterAddresses(IConstraints constraints, Address pa, List candidates) throws MatcherException {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        this.removeDuplicateAddresses(candidates);
        return this.filterCandidates(constraints, pa, candidates);
    }

    protected void removeDuplicateAddresses(List candidates) {
        HashSet<SWE_InternalBrowseAddress.StreetBasedIdentifier> set = new HashSet<SWE_InternalBrowseAddress.StreetBasedIdentifier>(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            SWE_InternalBrowseAddress SWEBrowseAddress = (SWE_InternalBrowseAddress)((Object)iter.next());
            SWE_InternalBrowseAddress.StreetBasedIdentifier identifier = SWEBrowseAddress.getStreetBasedIdentifier();
            if (set.contains(identifier)) {
                iter.remove();
                continue;
            }
            set.add(identifier);
        }
    }

    protected List filterCandidates(IConstraints constraints, Address pa, List candidates) {
        FieldScores thresholds = constraints.getHandler().getMatcherConstants().getFieldScores();
        StringScorer scorer = ((CoreHandler)constraints.getHandler()).getScoringHelper().makeStringScorer();
        ArrayList<SWE_InternalBrowseAddress> filteredCandidates = new ArrayList<SWE_InternalBrowseAddress>(candidates.size());
        for (SWE_InternalBrowseAddress address : candidates) {
            SWE_InternalBrowseAddress filteredAddress = this.filterAddress(address, pa, thresholds, constraints, scorer);
            if (filteredAddress == null) continue;
            filteredCandidates.add(filteredAddress);
        }
        Collections.sort(filteredCandidates, new BrowseAddressComparator(pa));
        return filteredCandidates;
    }

    protected SWE_InternalBrowseAddress filterAddress(InternalBrowseAddress address, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        SWE_InternalBrowseAddress filteredAddress = new SWE_InternalBrowseAddress((Address)address);
        int segmentCount = address.getSegmentCount();
        for (int index = 0; index < segmentCount; ++index) {
            Segment segment = address.getSegmentAt(index);
            if (!this.filterSegment(segment, inputAddress, thresholds, constraints, scorer)) continue;
            filteredAddress.addSegment(segment);
        }
        if (filteredAddress.getSegmentCount() > 0) {
            return filteredAddress;
        }
        return null;
    }

    protected boolean filterSegment(Segment segment, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        String[] recordAlts;
        SWE_GeoInfoRecord geoInfoRecord = (SWE_GeoInfoRecord)segment.getGeoInfoRecord();
        if (StringUtilities.isEmpty((String)inputAddress.getAreaName3()) && StringUtilities.isEmpty((String)inputAddress.getAreaName4()) && StringUtilities.isEmpty((String)inputAddress.getPostCode1())) {
            return false;
        }
        if (!this.passesPostcodeFilter(inputAddress.getPostCode1(), segment.getLeftPostCode1(), segment.getRightPostCode1(), thresholds.getPostalCode1(), constraints.isMustMatchPostalCode(), scorer)) {
            return false;
        }
        String leftValue = geoInfoRecord == null ? segment.getLeftAreaName1() : geoInfoRecord.getAreaName1();
        String rightValue = geoInfoRecord == null ? segment.getRightAreaName1() : null;
        String[] stringArray = recordAlts = geoInfoRecord == null ? null : geoInfoRecord.getAltAreaName1Array();
        if (!this.passesFilter(inputAddress.getAreaName1(), leftValue, rightValue, recordAlts, thresholds.getAreaName1(), constraints.isMustMatchArea1(), scorer)) {
            return false;
        }
        leftValue = geoInfoRecord == null ? segment.getLeftAreaName2() : geoInfoRecord.getAreaName2();
        rightValue = geoInfoRecord == null ? segment.getRightAreaName2() : null;
        String[] stringArray2 = recordAlts = geoInfoRecord == null ? null : geoInfoRecord.getAltAreaName2Array();
        if (!this.passesFilter(inputAddress.getAreaName2(), leftValue, rightValue, recordAlts, thresholds.getAreaName2(), constraints.isMustMatchArea2(), scorer)) {
            return false;
        }
        leftValue = geoInfoRecord == null ? segment.getLeftAreaName3() : geoInfoRecord.getAreaName3();
        rightValue = geoInfoRecord == null ? segment.getRightAreaName3() : null;
        recordAlts = geoInfoRecord == null ? null : geoInfoRecord.getAltAreaName3Array();
        String leftArea4 = geoInfoRecord == null ? segment.getLeftAreaName4() : geoInfoRecord.getAreaName4();
        String rightArea4 = geoInfoRecord == null ? segment.getRightAreaName4() : null;
        String[] recordAlts4 = geoInfoRecord == null ? null : geoInfoRecord.getAltAreaName4Array();
        boolean bAn3 = this.passesFilter(inputAddress.getAreaName3(), leftValue, rightValue, recordAlts, thresholds.getAreaName3(), constraints.isMustMatchArea3(), scorer);
        boolean bAn4 = this.passesFilter(inputAddress.getAreaName4(), leftArea4, rightArea4, recordAlts4, thresholds.getAreaName4(), constraints.isMustMatchArea4(), scorer);
        if (bAn3 && bAn4) {
            return true;
        }
        if (!StringUtilities.isEmpty((String)inputAddress.getAreaName4()) && this.passesFilter(inputAddress.getAreaName4(), leftValue, rightValue, recordAlts, thresholds.getAreaName3(), constraints.isMustMatchArea3(), scorer)) {
            return true;
        }
        return !StringUtilities.isEmpty((String)inputAddress.getAreaName3()) && this.passesFilter(inputAddress.getAreaName3(), leftArea4, rightArea4, recordAlts4, thresholds.getAreaName4(), constraints.isMustMatchArea4(), scorer);
    }

    protected boolean passesFilter(String input, String leftValue, String rightValue, String[] aliases, double scoreThreshold, boolean bMustMatch, StringScorer scorer) {
        if (input == null) {
            return true;
        }
        double score = scorer.scoreString(input, leftValue);
        if (score == 1.0) {
            return true;
        }
        if (!bMustMatch && score >= scoreThreshold) {
            return true;
        }
        score = scorer.scoreString(input, rightValue);
        if (score == 1.0) {
            return true;
        }
        if (!bMustMatch && score >= scoreThreshold) {
            return true;
        }
        if (aliases == null) {
            return false;
        }
        for (String alias : aliases) {
            score = scorer.scoreString(input, alias);
            if (score == 1.0) {
                return true;
            }
            if (bMustMatch || !(score >= scoreThreshold)) continue;
            return true;
        }
        return false;
    }

    protected boolean passesPostcodeFilter(String input, String leftValue, String rightValue, double scoreThreshold, boolean bMustMatch, StringScorer scorer) {
        if (input == null) {
            return true;
        }
        double score = scorer.scoreString(input, leftValue);
        if (score == 1.0) {
            return true;
        }
        if (!bMustMatch && score >= scoreThreshold) {
            return true;
        }
        score = scorer.scoreString(input, rightValue);
        if (score == 1.0) {
            return true;
        }
        return !bMustMatch && score >= scoreThreshold;
    }
}

