/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.SWE.SWELanguageSoundex;
import com.mapinfo.mapmarker.SWE.SWE_ScoringHelper;
import com.mapinfo.mapmarker.SWE.dp.SWE_DataConstructionParser;
import com.mapinfo.mapmarker.SWE.dp.SWE_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.SWE.dp.SWE_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.SWE.dp.SWE_PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.SWE.dp.SWE_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_DataFileMasksProvider;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_StreetBuilder;
import com.mapinfo.mapmarker.SWE.dp.binary.index.SWE_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.SWE.dp.intermediate.SWE_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public abstract class SWE_AbstractDataProvider
extends AbstractDataProvider {
    static MiVersion m_version = new MiVersion(4, 0, 0);
    private MMJComplexDataFileMetadata geoInfoMetadata;
    private MMJComplexDataFileMetadata postInfoMetadata;
    private MMJComplexDataFileMetadata streetMetadata;

    public void processStreets(boolean createStatistics) throws DataCreationException {
        String dataSetPath = this.m_processProperties.getProperty("dataSetPath");
        ((SWE_StreetBuilder)this.m_dataBuilder).initGeoInfoExactLookupIndex(dataSetPath);
        super.processStreets(createStatistics);
        Set<String> missingKeys = SWE_StreetBuilder.getMissingGeoInfoKeys();
        if (missingKeys != null && missingKeys.size() > 0) {
            DataCreationLogger.getLogger().logInternalError("");
            DataCreationLogger.getLogger().logInternalError("The following geoinfo keys could not be located:");
            for (String key : missingKeys) {
                DataCreationLogger.getLogger().logInternalError(key);
            }
            DataCreationLogger.getLogger().logInternalError("");
        }
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_dataBuilder = new SWE_StreetBuilder();
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new Post2SacDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String geo2sac_operation = processingProperties.getProperty("geo2sac_flag");
        if (geo2sac_operation != null) {
            this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new SWE_Geo2SacDataSourceRecordConvertorImpl(processingProperties, new SWELanguageSoundex()), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new SWE_PostInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(false));
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new SWE_GeoInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String processStreets = (String)processingProperties.get("street_create");
        if (processStreets != null && processStreets.equals("YES")) {
            SWE_StreetDataSourceRecordConvertorImpl streetRecordConvertor = new SWE_StreetDataSourceRecordConvertorImpl(new SWELanguageSoundex(), processingProperties, new CollationKeyGenerator(new Locale("se", "SE"), SWE_ScoringHelper.getCollationRules()), new SWE_DataConstructionParser(), new Constraints());
            this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)streetRecordConvertor, (IIntermediateDataHandler)new SWE_IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp")), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new SWE_MMJStreetRecordComparator(), new MMJSegmentComparer());
        }
    }

    protected abstract IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.streetMetadata == null) {
            this.streetMetadata = new MMJComplexDataFileMetadata();
            this.setMetaDataProperties(this.streetMetadata, SWE_DataFileMasksProvider.buildStreetDataFileMasks());
            this.streetMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.streetMetadata;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (this.postInfoMetadata == null) {
            this.postInfoMetadata = new MMJComplexDataFileMetadata();
            this.setMetaDataProperties(this.postInfoMetadata, SWE_DataFileMasksProvider.buildPostInfoDataFileMasks());
            this.postInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.postInfoMetadata;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.geoInfoMetadata == null) {
            this.geoInfoMetadata = new MMJComplexDataFileMetadata();
            this.setMetaDataProperties(this.geoInfoMetadata, SWE_DataFileMasksProvider.buildGeoInfoDataFileMasks());
            this.geoInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.geoInfoMetadata;
    }

    private void setMetaDataProperties(MMJComplexDataFileMetadata metadata, DataFileMasks masks) {
        metadata.setDataFileMasks(masks);
        metadata.setCountry("SWE");
        metadata.setXPow10((byte)5);
        metadata.setYPow10((byte)5);
        metadata.setVersion(m_version);
    }

    public boolean supportsReverseGeocode() {
        return true;
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        return new SWE_GeoInfoSoundexIndexer();
    }
}

