/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWE_InternalCandidateAddress;
import com.mapinfo.mapmarker.SWE.SWE_Range;
import com.mapinfo.mapmarker.SWE.SWE_StreetCandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GenericAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class SWE_AddressFetcher
extends GenericAddressFetcher {
    public SWE_AddressFetcher(Properties localSettings, Properties localStrings) {
        super(localSettings, localStrings);
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        super.populateCandidateFromData(cand, street, streetOffset, metadata);
        HashMap adFields = cand.getAdditionalFields();
        GenericStreet genericStreet = (GenericStreet)street;
        if (genericStreet.hasBoolean(32) && GenericDataItemAccessor.getDataBool((int)32, (GenericDataItem)genericStreet)) {
            adFields.put("POST_STREET_TYPE_SEPARATOR", " ");
        }
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new SWE_InternalCandidateAddress((Address)street);
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new SWE_StreetCandidateAddress();
    }

    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        long geoOffset;
        GeoInfoRecord geoRecord;
        IGeoInfoFetcher fetcher;
        super.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
        int leftPostcode = 0;
        int rightPostcode = 0;
        if (genericSegment.hasShort(32)) {
            rightPostcode = leftPostcode = GenericDataItemAccessor.getDataShort((int)32, (GenericDataItem)genericSegment);
        } else if (genericSegment.hasInteger(32)) {
            rightPostcode = leftPostcode = GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericSegment);
        } else {
            if (genericSegment.hasShort(33)) {
                leftPostcode = GenericDataItemAccessor.getDataShort((int)33, (GenericDataItem)genericSegment);
            } else if (genericSegment.hasInteger(33)) {
                leftPostcode = GenericDataItemAccessor.getDataInt((int)33, (GenericDataItem)genericSegment);
            }
            if (genericSegment.hasShort(34)) {
                rightPostcode = GenericDataItemAccessor.getDataShort((int)34, (GenericDataItem)genericSegment);
            } else if (genericSegment.hasInteger(34)) {
                rightPostcode = GenericDataItemAccessor.getDataInt((int)34, (GenericDataItem)genericSegment);
            }
        }
        if (leftPostcode > 0) {
            segment.setLeftPostCode1(StringUtilities.intToLeadingZeroString((int)5, (int)leftPostcode));
        }
        if (rightPostcode > 0) {
            segment.setRightPostCode1(StringUtilities.intToLeadingZeroString((int)5, (int)rightPostcode));
        }
        if ((fetcher = dict.getGeoInfoFetcher()) != null && (geoRecord = fetcher.getGeoInfoRecord(geoOffset = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericSegment))) != null) {
            segment.setGeoInfoRecord(geoRecord);
        }
    }

    protected Range makeRange() {
        return new SWE_Range();
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        super.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
        if (genericRange.hasBoolean(32)) {
            ((SWE_Range)range).setArtificialRange(true);
            if (GenericDataItemAccessor.getDataBool((int)32, (GenericDataItem)genericRange)) {
                ((SWE_Range)range).setHasHouseForInterpolation(true);
            }
        }
    }
}

