/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.utils.BlobUtilities;
import java.io.IOException;

public class SWE_GeoInfoPreLoadedDataHelper
extends GeoInfoPreLoadedDataHelper {
    public MMJDataFileMetadata getMetadataType() {
        return new MMJComplexDataFileMetadata();
    }

    protected GeoInfoRecord makeGeoInfoRecord() {
        return new SWE_GeoInfoRecord();
    }

    public void populateLocalGeoInfo(GeoInfoRecord geoInfoRecord, IDataFileDataItem dataFileDataItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        SWE_GeoInfoRecord record = (SWE_GeoInfoRecord)geoInfoRecord;
        GeoInfoDataItem dataItem = (GeoInfoDataItem)dataFileDataItem;
        try {
            String[] arr = record.getAltAreaName1Array();
            if (arr != null && arr.length > 0) {
                dataItem.putBlob(32, BlobUtilities.encode((String[])arr));
            }
            if ((arr = record.getAltAreaName2Array()) != null && arr.length > 0) {
                dataItem.putBlob(33, BlobUtilities.encode((String[])arr));
            }
            if ((arr = record.getAltAreaName3Array()) != null && arr.length > 0) {
                dataItem.putBlob(34, BlobUtilities.encode((String[])arr));
            }
            if ((arr = record.getAltAreaName4Array()) != null && arr.length > 0) {
                dataItem.putBlob(35, BlobUtilities.encode((String[])arr));
            }
        }
        catch (IOException e) {
            throw new DataCreationException((Throwable)e);
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate geoinfo data for record:");
            DataCreationLogger.getLogger().logInternalError(((Object)((Object)record)).toString());
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }

    public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
        SWE_GeoInfoRecord record = (SWE_GeoInfoRecord)((Object)super.makeDataRecord(item, metadata));
        GenericDataItem genericItem = (GenericDataItem)item;
        try {
            byte[] bytes;
            if (genericItem.hasBlob(32)) {
                bytes = GenericDataItemAccessor.getDataBlob((int)32, (GenericDataItem)genericItem);
                record.setAltAreaName1Array(BlobUtilities.decodeStringArray((byte[])bytes));
            }
            if (genericItem.hasBlob(33)) {
                bytes = GenericDataItemAccessor.getDataBlob((int)33, (GenericDataItem)genericItem);
                record.setAltAreaName2Array(BlobUtilities.decodeStringArray((byte[])bytes));
            }
            if (genericItem.hasBlob(34)) {
                bytes = GenericDataItemAccessor.getDataBlob((int)34, (GenericDataItem)genericItem);
                record.setAltAreaName3Array(BlobUtilities.decodeStringArray((byte[])bytes));
            }
            if (genericItem.hasBlob(35)) {
                bytes = GenericDataItemAccessor.getDataBlob((int)35, (GenericDataItem)genericItem);
                record.setAltAreaName4Array(BlobUtilities.decodeStringArray((byte[])bytes));
            }
        }
        catch (IOException e) {
            throw new LocalizationException((Throwable)e);
        }
        return record;
    }
}

