/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.AbstractMMJAlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class SWE_MMJRangeRecord
extends MMJRangeRecord {
    private boolean isArtificialRange = false;
    private boolean countsAsSingleArtificialHouse = false;

    public SWE_MMJRangeRecord() {
    }

    public SWE_MMJRangeRecord(MMJRangeRecord orig) {
        ParsedNumber number;
        this.copy((AbstractMMJAlternateDataRecord)orig);
        this.setPlaceName(orig.getPlaceName());
        this.setIntermediateDataRecordArray(orig.getIntermediateDataRecordArray());
        this.setIsPointRange(orig.isPointRange());
        this.setOddEven(orig.getOddEven());
        if (orig.isLeft()) {
            this.setLeft();
        } else {
            this.setRight();
        }
        this.setPoint(orig.getPoint());
        this.setPointRangeLocationPrecision(orig.getPointRangeLocationPrecision());
        if (orig.hasAdditionalFields()) {
            HashMap addFlds = new HashMap();
            for (String key : orig.getAdditionalFields().keySet()) {
                addFlds.put(key, orig.getAdditionalFields().get(key));
            }
            this.setAdditionalFields(addFlds);
        }
        if ((number = orig.getFromHouse()) != null) {
            this.setFromHouse(number.getCombinedAddressNumber());
        }
        if ((number = orig.getToHouse()) != null) {
            this.setToHouse(number.getCombinedAddressNumber());
        }
    }

    public boolean isArtificialRange() {
        return this.isArtificialRange;
    }

    public void setIsArtificialRange(boolean bArtificial) {
        this.isArtificialRange = bArtificial;
    }

    public boolean isValid() {
        boolean bValid = super.isValid();
        if (bValid && this.getFromHouse().hasAddressSuffix() && this.getToHouse().hasAddressSuffix() && this.getFromHouse().getAddressNumber() != this.getToHouse().getAddressNumber() && !StringUtilities.equalStrings((String)this.getFromHouse().getAddressSuffix(), (String)this.getToHouse().getAddressSuffix())) {
            return false;
        }
        return bValid;
    }

    public boolean isCountsAsSingleArtificialHouse() {
        return this.countsAsSingleArtificialHouse;
    }

    public void setCountsAsSingleArtificialHouse(boolean countsAsSingleArtificialHouse) {
        this.countsAsSingleArtificialHouse = countsAsSingleArtificialHouse;
    }
}

