/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.intermediate;

import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJRangeRecord;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJSegmentRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import java.util.HashMap;

public class SWE_IntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    public SWE_IntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetRecord2DataItem(record, item);
        Address address = record.getAddress();
        if (address.hasAdditionalFields()) {
            try {
                if (address.getAdditionalFields().containsKey("POST_STREET_TYPE_SEPARATOR")) {
                    item.putBoolean(32, true);
                }
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataSourceException(14, (Throwable)e);
            }
        }
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetDataItem2Record(record, item);
        if (item.hasBoolean(32)) {
            boolean bHadFields;
            Address address = record.getAddress();
            HashMap adFields = address.getAdditionalFields();
            boolean bl = bHadFields = adFields != null;
            if (!bHadFields) {
                throw new DataSourceException("record has no additional fields");
            }
            adFields.put("POST_STREET_TYPE_SEPARATOR", " ");
        }
    }

    protected MMJSegmentRecord getSegmentRecordType() {
        return new SWE_MMJSegmentRecord();
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new SWE_MMJRangeRecord();
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        if (item.hasBoolean(32)) {
            ((SWE_MMJRangeRecord)record).setIsArtificialRange(true);
            try {
                if (item.getBoolean(32)) {
                    ((SWE_MMJRangeRecord)record).setCountsAsSingleArtificialHouse(true);
                }
            }
            catch (MMJETypeArraySizeExceededException ex) {
                throw new DataSourceException("record said it had RANGE_BOOL_IS_ARTIFICIAL_SINGLE_HOUSE but it had no value");
            }
        }
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        SWE_MMJRangeRecord sweRecord = (SWE_MMJRangeRecord)record;
        if (sweRecord.isArtificialRange()) {
            boolean bHouseCount = sweRecord.isCountsAsSingleArtificialHouse();
            try {
                item.putBoolean(32, bHouseCount);
            }
            catch (MMJETypeArraySizeExceededException ex) {
                throw new DataSourceException("unable to set RANGE_BOOL_IS_ARTIFICIAL_SINGLE_HOUSE");
            }
        }
    }
}

