/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.ud.tab;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.SWE.SWELanguageSoundex;
import com.mapinfo.mapmarker.SWE.SWE_ScoringHelper;
import com.mapinfo.mapmarker.SWE.dp.SWE_DataConstructionParser;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_StreetBuilder;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_TabDataProvider;
import com.mapinfo.mapmarker.SWE.dp.binary.index.SWE_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.SWE.dp.intermediate.SWE_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.SWE.dp.ud.SWE_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.SWE.dp.ud.tab.SWE_UDGeoInfoDataHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class SWE_TabUDDataProvider
extends AbstractUDDataProvider {
    private static GeoInfoSoundexIndexer m_GeoInfoSoundexIndexer = null;
    private SWE_TabDataProvider m_tabDataProvider = new SWE_TabDataProvider();
    private String m_geoInfoPathAndBaseName;
    private SWE_UDStreetDataSourceRecordConvertor m_SWEStreetRecordConverter = null;
    private static final int DATATYPE_USER_DICTIONARY = 10;

    @Override
    public MMJComplexDataFileMetadata getGeoInfoMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metadata = this.m_tabDataProvider.getGeoInfoMetadata();
        metadata.setDataFileMasks(this.getGeoInfoDataFileMasks());
        metadata.setVendorCode(10);
        return metadata;
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        if (m_GeoInfoSoundexIndexer == null) {
            m_GeoInfoSoundexIndexer = new SWE_GeoInfoSoundexIndexer();
        }
        return m_GeoInfoSoundexIndexer;
    }

    @Override
    public MMJComplexDataFileMetadata getPostInfoMetadata() throws DataCreationException {
        return null;
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_dataBuilder = new SWE_StreetBuilder();
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_postInfoDataHandler = null;
        this.m_geoInfoDataHandler = new SWE_UDGeoInfoDataHandler();
        Constraints constraints = new Constraints();
        this.m_SWEStreetRecordConverter = new SWE_UDStreetDataSourceRecordConvertor(processingProperties, (UDPost2SacDataHandler)this.m_post2sacDataHandler, (UDGeo2SacDataHandler)this.m_geo2sacDataHandler, new SWELanguageSoundex(), new CollationKeyGenerator(new Locale("se", "SWE"), SWE_ScoringHelper.getCollationRules()), new SWE_DataConstructionParser(), constraints, (SWE_UDGeoInfoDataHandler)this.m_geoInfoDataHandler);
        String tempStreetFileFullName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"street.tmp");
        this.m_streetDataHandler = new TabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)this.m_SWEStreetRecordConverter, (IIntermediateDataHandler)new SWE_IntermediateStreetDataFileFormatHandler(tempStreetFileFullName), (MMJStreetRecordComparator)new SWE_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String geoUDFilePath = processingProperties.getProperty("geoInfo_outputFilePath");
        this.m_geoInfoPathAndBaseName = geoUDFilePath + File.separator + "geoinfo";
    }

    public void processStreets(boolean createStatistics) throws DataCreationException {
        try {
            super.processStreets(createStatistics);
        }
        finally {
            if (this.m_SWEStreetRecordConverter != null) {
                this.m_SWEStreetRecordConverter.close();
                this.m_SWEStreetRecordConverter = null;
            }
        }
    }

    @Override
    public void preProcessStreetDataSet() throws DataCreationException {
        super.preProcessStreetDataSet();
    }

    @Override
    public void createOtherFiles() throws DataCreationException {
        super.createOtherFiles();
        this.convertGeoInfoIndexFile();
    }

    private void convertGeoInfoIndexFile() throws DataCreationException {
        this.processGeoInfo(false);
        IndexFileConvertor geoInfoStandardConvertor = this.getExactMatchGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tdx", this.m_geoInfoPathAndBaseName + ".jdx");
        if (geoInfoStandardConvertor != null) {
            try {
                DataCreationLogger.getLogger().logStatus("Creating geoInfo exact index file.");
                geoInfoStandardConvertor.convert();
                DataCreationLogger.getLogger().logStatus("Finished creating geoInfo exact index file.");
            }
            catch (DataCreationException e) {
                throw new DataCreationException(400, (Throwable)e);
            }
        }
        this.deleteFile(this.m_geoInfoPathAndBaseName + ".tdx");
        GeoInfoSoundexIndexer indexer = this.getGeoInfoSoundexIndexer();
        if (indexer != null) {
            DataCreationLogger.getLogger().logStatus("Creating temporary geoInfo soundex index file.");
            indexer.processGeoInfoFile(this.m_geoInfoPathAndBaseName);
            DataCreationLogger.getLogger().logStatus("Finished creating temporary geoInfo soundex index file.");
            IndexFileConvertor geoInfoSoundexConvertor = this.getSoundexGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tsx", this.m_geoInfoPathAndBaseName + ".sdx");
            if (geoInfoSoundexConvertor != null) {
                try {
                    DataCreationLogger.getLogger().logStatus("Creating geoInfo soundex index file.");
                    geoInfoSoundexConvertor.convert();
                    this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
                    DataCreationLogger.getLogger().logStatus("Finished creating soundex geoInfo index file.");
                }
                catch (DataCreationException e) {
                    throw new DataCreationException(400, (Throwable)e);
                }
            } else {
                this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
            }
        }
    }

    public DataFileMasks getPostInfoDataFileMasks() {
        return null;
    }

    public DataFileMasks getGeoInfoDataFileMasks() {
        return new DataFileMasks();
    }

    public MMJComplexDataFileMetadata getStreetMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metaData = this.m_tabDataProvider.getStreetMetadata();
        metaData.setVendorCode(10);
        return metaData;
    }
}

