/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class PickByHouseNumberRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCloseMatch, ICandidate otherCloseMatch) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCloseMatch;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCloseMatch;
        if (other.getMainAddressScore() == 1.0 && best.getMainAddressScore() != 1.0) {
            return false;
        }
        if (best.getAreaName3Score() < other.getAreaName3Score()) {
            return false;
        }
        if (best.getPostCode1Score() < 1.0 && other.getPostCode1Score() == 1.0 && (best.getAddressNumberScore() < 1.0 || best.getPostThoroughfareTypeScore() < 1.0)) {
            return false;
        }
        if (best.getPreDirectionalScore() < 1.0 && other.getPreDirectionalScore() == 1.0) {
            return false;
        }
        if (best.getPostThoroughfareTypeScore() < 1.0 && other.getPostThoroughfareTypeScore() == 1.0) {
            return false;
        }
        if (best.getPreDirectionalScore() == other.getPreDirectionalScore() && best.getPreDirectionalScore() == 1.0 && StringUtilities.isEmpty((String)best.getPreDirectional()) != StringUtilities.isEmpty((String)other.getPreDirectional())) {
            return false;
        }
        if (best.getAddressNumberScore() == 1.0 && other.getAddressNumberScore() < 1.0) {
            return true;
        }
        if (!StringUtilities.isEmpty((String)inputAddresses[0].getAddressNumber()) && !StringUtilities.isEmpty((String)best.getAddressNumber()) && StringUtilities.isEmpty((String)other.getAddressNumber())) {
            return true;
        }
        if (best.getAddressNumberScore() >= 0.95 && other.getAddressNumberScore() < 0.1) {
            return true;
        }
        if (!StringUtilities.isEmpty((String)inputAddresses[0].getAddressNumber()) && best.hasClosestRange()) {
            if (!other.hasMatchingRange() && !other.hasClosestRange()) {
                return true;
            }
            if (other.hasClosestRange()) {
                Range bestRange = best.getSegment().getRangeAt(best.getClosestRangeNumber(), best.getClosestSegmentSide());
                Range otherRange = other.getSegment().getRangeAt(other.getClosestRangeNumber(), other.getClosestSegmentSide());
                if (bestRange.getRangeOffset() < otherRange.getRangeOffset()) {
                    return true;
                }
            }
        }
        return false;
    }
}

