/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class UnusualStreetNameFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate best, ICandidate other) {
        boolean bOtherFits;
        InternalCandidateAddress bestCandidate = (InternalCandidateAddress)best;
        InternalCandidateAddress otherCandidate = (InternalCandidateAddress)other;
        String inHouse = inputAddresses[0].getAddressNumber();
        String inStreet = inputAddresses[0].getMainAddress();
        if (inHouse == null || inStreet == null) {
            return false;
        }
        String bestAlt = bestCandidate.getGenericField4();
        String otherAlt = otherCandidate.getGenericField4();
        boolean bBestFits = bestAlt != null && bestAlt.indexOf(inHouse) > 0;
        boolean bl = bOtherFits = otherAlt != null && otherAlt.indexOf(inHouse) > 0;
        if (bBestFits && !bOtherFits) {
            return true;
        }
        String postAddrItemBest = bestCandidate.getPostAddress();
        String postAddrItemOther = otherCandidate.getPostAddress();
        bBestFits = StringUtilities.equalStrings((String)inHouse, (String)postAddrItemBest);
        bOtherFits = StringUtilities.equalStrings((String)inHouse, (String)postAddrItemOther);
        return bBestFits && !bOtherFits;
    }
}

