/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class SWE_AddressTerm {
    private static final String COMMON_TERMS_KEY = "common_words";
    private static final String PROVINCE_NAME_KEY = "province_name";
    private static List<String> commonTermList;
    private static List<String> provinceNameList;
    private static Properties properties;
    private static Properties diacritics;

    public static String removeCommonTerms(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(s, " ", true);
        while (tokens.hasMoreTokens()) {
            String term = tokens.nextToken();
            if (SWE_AddressTerm.isCommonTerm(term)) continue;
            buff.append(term);
        }
        String result = buff.toString().trim();
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    private static void loadCommonTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String commonWord = st.nextToken().trim();
                if (commonWord.length() <= 0) continue;
                commonTermList.add(commonWord.toUpperCase());
            }
        }
    }

    private static void loadProvinceNames(String raw) {
        String province;
        if (raw != null && (province = raw.trim()).length() > 0) {
            provinceNameList.add(province.toUpperCase());
        }
    }

    public static boolean isProvince(String test) {
        return test != null && provinceNameList.contains(test);
    }

    public static Iterator<String> getProvinceIterator() {
        return provinceNameList.iterator();
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isCommonTerm(String term) {
        if (commonTermList != null) {
            return commonTermList.contains(term.toUpperCase());
        }
        return false;
    }

    protected static void loadDiacritics() {
        String fileName = "com/mapinfo/mapmarker/SWE/SWESpecialCharacters.properties";
        try {
            diacritics = FileUtilities.loadProperties((String)fileName);
        }
        catch (FileNotFoundException fx) {
            throw new RuntimeException("Could not find SWESpecialCharacters.properties", fx);
        }
        catch (IOException iox) {
            throw new RuntimeException("Could not read SWESpecialCharacters.properties", iox);
        }
    }

    public static String removeDiacritics(String s) {
        if (s == null || s.equalsIgnoreCase("")) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            String tmp = String.valueOf(chars[i]);
            if (diacritics.containsKey(tmp)) {
                result.append(diacritics.getProperty(tmp));
                continue;
            }
            result.append(tmp);
        }
        if (result.toString().trim().length() > 0) {
            return result.toString().trim();
        }
        return null;
    }

    static {
        try {
            SWE_AddressTerm.loadDiacritics();
            provinceNameList = new ArrayList<String>(20);
            commonTermList = new ArrayList<String>(20);
            properties = new Properties();
            properties.load(SWE_AddressTerm.class.getResourceAsStream("SWE_AddressTerm.properties"));
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith(COMMON_TERMS_KEY)) {
                    SWE_AddressTerm.loadCommonTerms(properties.getProperty(key));
                    continue;
                }
                if (!key.startsWith(PROVINCE_NAME_KEY)) continue;
                SWE_AddressTerm.loadProvinceNames(properties.getProperty(key));
            }
            commonTermList = Collections.unmodifiableList(commonTermList);
            provinceNameList = Collections.unmodifiableList(provinceNameList);
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for SWE_Parser.");
        }
    }
}

