/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.parser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.parser.SWE_AddressTerm;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class SWE_ParsePostAddressRule
implements IParseRule {
    public static final int POST_CODE_INVALID = 0;
    public static final int POST_CODE_FULL = 3;
    public static final int POST_CODE_PARTIAL = 4;

    public static int getPostCodeType(String postCode) {
        if (postCode.length() == 5) {
            return 3;
        }
        if (postCode.length() >= 3) {
            return 4;
        }
        return 0;
    }

    public static String getOutwardSortingCode(String postCode) {
        if (postCode == null || postCode.trim().length() == 0) {
            return null;
        }
        if (postCode.length() >= 3) {
            return postCode.trim().substring(0, 3);
        }
        return postCode.trim();
    }

    protected String cleanPostCode(String code) {
        if (StringUtilities.isNumeric((String)(code = code.trim()))) {
            if (code.length() > 5) {
                code = code.substring(0, 5);
            }
            return code;
        }
        StringTokenizer st = new StringTokenizer(code, " -");
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (StringUtilities.isNumeric((String)token)) {
                sb.append(token);
                continue;
            }
            if (!StringUtilities.hasNumeric((String)token)) continue;
            sb.append(StringUtilities.trimToChars((String)token, (String)"1234567890"));
        }
        if (sb.length() > 5) {
            sb.setLength(5);
        }
        return sb.toString();
    }

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String post;
        String code = pa.getPostCode1();
        if (code != null && StringUtilities.hasNumeric((String)code)) {
            pa.setPostCode1(this.cleanPostCode(code));
        }
        pa.setAreaName1(SWE_AddressUtils.expandAbbreviations(SWE_AddressUtils.uppercase(pa.getAreaName1())));
        pa.setAreaName2(SWE_AddressUtils.expandAbbreviations(SWE_AddressUtils.uppercase(pa.getAreaName2())));
        pa.setAreaName3(SWE_AddressUtils.expandAbbreviations(SWE_AddressUtils.uppercase(pa.getAreaName3())));
        pa.setAreaName4(SWE_AddressUtils.expandAbbreviations(SWE_AddressUtils.uppercase(pa.getAreaName4())));
        String city = pa.getAreaName3();
        city = SWE_AddressUtils.expandAbbreviations(city);
        if (city != null) {
            pa.setAreaName3(city);
        }
        if (StringUtilities.isEmpty((String)(post = pa.getPostAddress()))) {
            return;
        }
        pa.setPostAddress(null);
        post = SWE_AddressUtils.expandAbbreviations(post.toUpperCase());
        StringTokenizer tokens = new StringTokenizer(post, " ();\t/.\"',\\");
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        StringBuilder sb = new StringBuilder(post.length());
        StringBuilder secondary = new StringBuilder(post.length());
        for (int i = 0; i < listOfTokens.size(); ++i) {
            String token = (String)listOfTokens.get(i);
            if (StringUtilities.hasNumeric((String)token)) {
                secondary.append(token);
                if (sb.length() <= 0 || !StringUtilities.isEmpty((String)pa.getAreaName1())) continue;
                String rest = this.separateLan(sb.toString(), pa);
                pa.setAreaName3(rest);
                continue;
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(token);
        }
        if (sb.length() > 0) {
            String probableCity = sb.toString();
            if (StringUtilities.isEmpty((String)pa.getAreaName1())) {
                probableCity = this.separateLan(sb.toString(), pa);
            }
            if (!StringUtilities.isEmpty((String)probableCity)) {
                int spaceIdx = probableCity.indexOf(32);
                if (spaceIdx > 0 && spaceIdx == probableCity.lastIndexOf(32)) {
                    String second;
                    StringTokenizer st = new StringTokenizer(probableCity);
                    String first = st.nextToken();
                    if (StringUtilities.equalStringsIgnoreCase((String)first, (String)(second = st.nextToken()))) {
                        pa.setAreaName3(first);
                        pa.setAreaName2(second);
                    } else {
                        pa.setAreaName3(probableCity);
                    }
                } else {
                    pa.setAreaName3(probableCity);
                }
            }
        }
        if (secondary.length() > 0) {
            pa.setPostCode1(this.cleanPostCode(secondary.toString()));
        }
    }

    protected String separateLan(String name, Address pa) {
        if (SWE_AddressTerm.isProvince(name)) {
            pa.setAreaName1(name);
            return null;
        }
        Iterator<String> iterator = SWE_AddressTerm.getProvinceIterator();
        while (iterator.hasNext()) {
            String lan = iterator.next();
            int idx = name.indexOf(lan);
            if (idx < 0) continue;
            String areaName1 = name.substring(idx, idx + lan.length());
            pa.setAreaName1(areaName1);
            if (idx == 0) {
                return name.substring(lan.length()).trim();
            }
            if (idx == name.length() - lan.length()) {
                return name.substring(0, idx).trim();
            }
            String pre = name.substring(0, idx).trim();
            String post = name.substring(idx + lan.length()).trim();
            return pre;
        }
        return name;
    }
}

