/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.parser;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class SWE_UnitTypes {
    private static final String UNIT_TYPES_FILE = "SWE_UnitTypes.properties";
    private static final Set<String> UNIT_TYPES;

    public static boolean isUnitType(String str) {
        if (StringUtilities.isEmpty((String)str)) {
            return false;
        }
        return UNIT_TYPES.contains(str.toUpperCase());
    }

    private SWE_UnitTypes() {
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(SWE_UnitTypes.class.getResourceAsStream(UNIT_TYPES_FILE));
            HashSet<String> unitTypes = new HashSet<String>();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String type = ((String)e.nextElement()).toUpperCase();
                unitTypes.add(type);
                unitTypes.add(type + '.');
            }
            UNIT_TYPES = Collections.unmodifiableSet(unitTypes);
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for SWE_Parser.");
        }
    }
}

